/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.item;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.GeckoLibUtil;
import ttv.migami.jeg.animations.GunAnimations;
import ttv.migami.jeg.client.render.gun.animated.AnimatedGunRenderer;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageCasing;

public class AnimatedGunItem
extends GunItem
implements GeoAnimatable,
GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String gunID;
    private int heartBeat = 60;

    public AnimatedGunItem(Item.Properties properties, String path) {
        super(properties);
        this.gunID = path;
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        long id = GeoItem.getId((ItemStack)stack);
        if (stack.m_41720_() == ModItems.FINGER_GUN.get() && !stack.m_41783_().m_128471_("IgnoreAmmo")) {
            stack.m_41784_().m_128379_("IgnoreAmmo", true);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_21205_().m_41720_() == ModItems.HYPERSONIC_CANNON.get()) {
                --this.heartBeat;
                if (this.heartBeat == 0) {
                    player.m_5496_(SoundEvents.f_215762_, 0.3f, 1.0f);
                    this.heartBeat = 30;
                }
                if (this.heartBeat < 0) {
                    this.heartBeat = 30;
                }
            }
            if (stack == player.m_21205_()) {
                CompoundTag nbtCompound = stack.m_41784_();
                if (nbtCompound.m_128471_("IsShooting") && nbtCompound.m_128451_("AnimationTick") < 5) {
                    nbtCompound.m_128405_("AnimationTick", nbtCompound.m_128451_("AnimationTick") + 1);
                }
                if (nbtCompound.m_128451_("AnimationTick") >= 5) {
                    nbtCompound.m_128473_("IsShooting");
                    nbtCompound.m_128473_("AnimationTick");
                }
                if (nbtCompound.m_128471_("IsMeleeing") && nbtCompound.m_128451_("AnimationTick") < 5) {
                    nbtCompound.m_128405_("AnimationTick", nbtCompound.m_128451_("AnimationTick") + 1);
                }
                if (nbtCompound.m_128451_("AnimationTick") >= 5) {
                    nbtCompound.m_128473_("IsMeleeing");
                    nbtCompound.m_128473_("AnimationTick");
                }
                if (nbtCompound.m_128471_("IsInspecting") && nbtCompound.m_128451_("AnimationTick") < 5) {
                    nbtCompound.m_128405_("AnimationTick", nbtCompound.m_128451_("AnimationTick") + 1);
                }
                if (nbtCompound.m_128451_("AnimationTick") >= 5) {
                    nbtCompound.m_128473_("IsInspecting");
                    nbtCompound.m_128473_("AnimationTick");
                }
                int drawTick = this.getModifiedGun(player.m_21205_()).getGeneral().getDrawTimer();
                if (nbtCompound.m_128451_("DrawnTick") >= drawTick) {
                    nbtCompound.m_128379_("IsDrawing", false);
                }
                if (!nbtCompound.m_128471_("IsDrawing") && nbtCompound.m_128451_("DrawnTick") < drawTick) {
                    nbtCompound.m_128379_("IsDrawing", true);
                }
                if (nbtCompound.m_128471_("IsDrawing") && nbtCompound.m_128451_("DrawnTick") < drawTick) {
                    nbtCompound.m_128405_("DrawnTick", nbtCompound.m_128451_("DrawnTick") + 1);
                    if (stack.m_150930_((Item)ModItems.ROCKET_LAUNCHER.get())) {
                        player.m_5661_((Component)Component.m_237115_((String)"chat.jeg.rocket_ride").m_130940_(ChatFormatting.WHITE), true);
                    }
                    if (stack.m_150930_((Item)ModItems.FLAMETHROWER.get())) {
                        player.m_5661_((Component)Component.m_237115_((String)"chat.jeg.flamethrower").m_130940_(ChatFormatting.WHITE), true);
                    }
                }
                boolean isSprinting = player.m_20142_();
                boolean isAiming = (Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player);
                this.updateBooleanTag(nbtCompound, "IsAiming", isAiming);
                this.updateBooleanTag(nbtCompound, "IsRunning", isSprinting);
            } else {
                if (stack.m_41783_() == null) {
                    return;
                }
                if (stack == player.m_21205_()) {
                    return;
                }
                this.resetTags(stack);
            }
        }
    }

    public void resetTags(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag == null) {
            return;
        }
        compoundTag.m_128473_("IsDrawing");
        compoundTag.m_128473_("DrawnTick");
        compoundTag.m_128473_("IsShooting");
        compoundTag.m_128473_("IsReloading");
        compoundTag.m_128473_("IsInspecting");
        compoundTag.m_128473_("IsAiming");
        compoundTag.m_128473_("IsRunning");
        compoundTag.m_128473_("IsMeleeing");
        compoundTag.m_128473_("IsFirstPersonReload");
    }

    public void resetTags(CompoundTag compoundTag) {
        compoundTag.m_128473_("IsDrawing");
        compoundTag.m_128473_("IsShooting");
        compoundTag.m_128473_("IsReloading");
        compoundTag.m_128473_("IsInspecting");
        compoundTag.m_128473_("IsAiming");
        compoundTag.m_128473_("IsRunning");
        compoundTag.m_128473_("IsMeleeing");
        compoundTag.m_128473_("IsFirstPersonReload");
    }

    private void updateBooleanTag(CompoundTag nbt, String key, boolean value) {
        if (value) {
            nbt.m_128379_(key, true);
        } else {
            nbt.m_128473_(key);
        }
    }

    private void soundListener(SoundKeyframeEvent<GeoAnimatable> gunItemSoundKeyframeEvent) {
        Player player = ClientUtils.getClientPlayer();
        if (player != null) {
            if (!(player.m_21205_().m_41720_() instanceof GunItem)) {
                return;
            }
            Gun gun = this.getModifiedGun(player.m_21205_());
            switch (gunItemSoundKeyframeEvent.getKeyframeData().getSound()) {
                case "rustle": {
                    player.m_5496_((SoundEvent)ModSounds.GUN_RUSTLE.get(), 1.0f, 1.0f);
                    break;
                }
                case "screw": {
                    player.m_5496_((SoundEvent)ModSounds.GUN_SCREW.get(), 1.0f, 1.0f);
                    break;
                }
                case "reload_mag_out": {
                    SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(gun.getSounds().getReloadStart());
                    if (sound == null) break;
                    player.m_5496_(sound, 1.0f, 1.0f);
                    break;
                }
                case "reload_mag_in": {
                    SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(gun.getSounds().getReloadLoad());
                    if (sound == null) break;
                    player.m_5496_(sound, 1.0f, 1.0f);
                    break;
                }
                case "reload_end": {
                    SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(gun.getSounds().getReloadEnd());
                    if (sound == null) break;
                    player.m_5496_(sound, 1.0f, 1.0f);
                    break;
                }
                case "ejector_pull": {
                    SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(gun.getSounds().getEjectorPull());
                    if (sound == null) break;
                    player.m_5496_(sound, 1.0f, 1.0f);
                    break;
                }
                case "ejector_release": {
                    SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(gun.getSounds().getEjectorRelease());
                    if (sound == null) break;
                    player.m_5496_(sound, 1.0f, 1.0f);
                    break;
                }
                case "jammed": {
                    player.m_5496_(SoundEvents.f_11668_, 0.8f, 1.5f);
                }
            }
        }
    }

    private void particleListener(ParticleKeyframeEvent<GeoAnimatable> gunItemParticleKeyframeEvent) {
        Player player = ClientUtils.getClientPlayer();
        if (player != null && player.m_21205_().m_41720_() instanceof AnimatedGunItem) {
            ItemStack itemStack = player.m_21205_();
            switch (gunItemParticleKeyframeEvent.getKeyframeData().getEffect()) {
                case "eject_casing": {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageCasing());
                }
            }
        }
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    @Override
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private AnimatedGunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new AnimatedGunRenderer(new ResourceLocation("jeg", AnimatedGunItem.this.gunID));
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{GunAnimations.genericIdleController(this).setSoundKeyframeHandler(this::soundListener).setParticleKeyframeHandler(this::particleListener)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

