/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.faction;

import com.mojang.brigadier.CommandDispatcher;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.entity.ai.AIType;
import ttv.migami.jeg.entity.ai.GunAttackGoal;
import ttv.migami.jeg.faction.Faction;
import ttv.migami.jeg.faction.GunMobValues;
import ttv.migami.jeg.faction.GunnerManager;
import ttv.migami.jeg.init.ModCommands;
import ttv.migami.jeg.init.ModTags;
import ttv.migami.jeg.item.GunItem;

@Mod.EventBusSubscriber(modid="jeg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunnerMobSpawner {
    public static final UUID GUN_FOLLOW_RANGE_MODIFIER_UUID = UUID.randomUUID();

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onSpecialSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (!GunMobValues.enabled) {
            return;
        }
        Mob entity = event.getEntity();
        if (!(entity instanceof PathfinderMob)) {
            return;
        }
        if (!entity.m_6095_().m_204039_(ModTags.Entities.GUNNER)) {
            return;
        }
        long totalDayTime = entity.m_9236_().m_46468_();
        int currentDay = (int)(totalDayTime / 24000L);
        if (currentDay < GunMobValues.minDays) {
            return;
        }
        int daysOverMin = currentDay - GunMobValues.minDays;
        int currentChance = Math.min(GunMobValues.initialChance + daysOverMin * GunMobValues.chanceIncrement, GunMobValues.maxChance);
        if (entity.m_217043_().m_188503_(100) >= currentChance) {
            return;
        }
        GunnerManager manager = GunnerManager.getInstance();
        Faction faction = manager.getFactionForMob(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
        if (faction != null) {
            entity.m_20049_("MobGunner");
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        GunnerManager manager;
        Faction faction;
        if (!GunMobValues.enabled) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)livingEntity;
        if (mob.f_19797_ >= 2) {
            return;
        }
        ItemStack heldItem = mob.m_21205_();
        if (mob.m_19880_().contains("MobGunner") && !(heldItem.m_41720_() instanceof GunItem) && (faction = (manager = new GunnerManager(GunnerManager.getConfigFactions())).getFactionForMob(ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_()))) != null) {
            boolean isCloseRange = mob.m_217043_().m_188499_();
            int stopRange = isCloseRange ? 7 : 20;
            Item gun = faction.getRandomGun(isCloseRange);
            AIType aiType = AIType.values()[mob.m_217043_().m_188503_(AIType.values().length)];
            boolean elite = (double)mob.m_217043_().m_188501_() < GunMobValues.eliteChance && GunMobValues.elitesEnabled;
            int aiLevel = faction.getAiLevel() + (elite ? 1 : 0);
            if (elite) {
                gun = faction.getEliteGun();
                GunnerMobSpawner.applyEliteAttributes(mob);
            }
            if (!mob.m_9236_().f_46443_ && !GunnerMobSpawner.hasGunAttackGoal(mob)) {
                mob.f_21345_.m_25352_(2, new GunAttackGoal<PathfinderMob>(mob, stopRange, 1.2f, aiType, aiLevel));
                mob.m_20049_("GunAttackAssigned");
            }
            ItemStack modifiedGun = GunnerMobSpawner.createModifiedGun(mob, gun);
            mob.m_8061_(EquipmentSlot.MAINHAND, modifiedGun);
            GunnerMobSpawner.extendFollowRange(mob);
        }
        if (heldItem.m_41720_() instanceof GunItem) {
            GunnerMobSpawner.reassessWeaponGoal(mob);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (!GunMobValues.enabled) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        mob.m_20137_("GunAttackAssigned");
        ItemStack heldItem = mob.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            GunnerMobSpawner.reassessWeaponGoal(mob);
        } else {
            GunnerMobSpawner.resetFollowRange(mob);
        }
    }

    public static boolean hasGunAttackGoal(PathfinderMob mob) {
        return mob.f_21345_.m_148105_().stream().anyMatch(goal -> goal.m_26015_() instanceof GunAttackGoal);
    }

    public static void reassessWeaponGoal(PathfinderMob mob) {
        if (mob.m_9236_().f_46443_ || GunnerMobSpawner.hasGunAttackGoal(mob)) {
            return;
        }
        AIType aiType = AIType.values()[mob.m_217043_().m_188503_(AIType.values().length)];
        boolean isCloseRange = mob.m_217043_().m_188499_();
        int stopRange = isCloseRange ? 7 : 20;
        int aiDifficulty = mob.m_217043_().m_188503_(4) + 1;
        mob.f_21345_.m_25352_(2, new GunAttackGoal<PathfinderMob>(mob, stopRange, 1.2f, aiType, aiDifficulty));
        mob.m_20049_("GunAttackAssigned");
        GunnerMobSpawner.extendFollowRange(mob);
    }

    private static void applyEliteAttributes(PathfinderMob mob) {
        mob.m_20049_("EliteGunner");
        mob.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42354_));
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 2, false, true));
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, -1, 1, false, false));
    }

    private static ItemStack createModifiedGun(PathfinderMob mob, Item gun) {
        ItemStack gunStack = new ItemStack((ItemLike)gun);
        if (gun instanceof GunItem) {
            GunItem gunItem = (GunItem)gun;
            if (gunStack.m_41783_() != null) {
                Gun gunModified = gunItem.getModifiedGun(gunStack);
                gunStack.m_41783_().m_128405_("AmmoCount", mob.m_217043_().m_188503_(gunModified.getReloads().getMaxAmmo()));
            }
        }
        return gunStack;
    }

    public static void extendFollowRange(PathfinderMob mob) {
        if (mob.m_21051_(Attributes.f_22277_) != null) {
            double additionalRange = 64.0 - mob.m_21051_(Attributes.f_22277_).m_22115_();
            AttributeModifier modifier = new AttributeModifier(GUN_FOLLOW_RANGE_MODIFIER_UUID, "Gun follow range modifier", additionalRange, AttributeModifier.Operation.ADDITION);
            if (!mob.m_21051_(Attributes.f_22277_).m_22109_(modifier)) {
                mob.m_21051_(Attributes.f_22277_).m_22125_(modifier);
            }
        }
    }

    public static void resetFollowRange(PathfinderMob mob) {
        if (mob.m_21051_(Attributes.f_22277_) != null) {
            mob.m_21051_(Attributes.f_22277_).m_22120_(GUN_FOLLOW_RANGE_MODIFIER_UUID);
        }
    }
}

