/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.monster.phantom;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.entity.monster.phantom.PhantomSwarmData;
import ttv.migami.jeg.init.ModCommands;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModSounds;

public class PhantomSwarmSpawner
implements CustomSpawner {
    private int nextTick;
    private final int MAX_SWARM_PARTICLE_TICK = 6000;
    private int swarmParticleTick = 6000;

    public int m_7995_(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!((Boolean)Config.COMMON.gunnerMobs.phantomSwarm.get()).booleanValue()) {
            return 0;
        }
        if (level.m_46791_().equals((Object)Difficulty.PEACEFUL)) {
            return 0;
        }
        if (!spawnEnemies || !level.m_46469_().m_46207_(GameRules.f_46124_)) {
            return 0;
        }
        PhantomSwarmData raidData = PhantomSwarmData.get(level);
        this.nextTick = raidData.getNextTick();
        if (!raidData.hasPhantomSwarm()) {
            return 0;
        }
        RandomSource random = level.f_46441_;
        --this.nextTick;
        raidData.setNextTick(this.nextTick);
        int playerCount2 = level.m_6907_().size();
        if (playerCount2 < 1) {
            return 0;
        }
        Player swarmPlayer = (Player)level.m_6907_().get(random.m_188503_(playerCount2));
        if (swarmPlayer.m_5833_()) {
            return 0;
        }
        if (--this.swarmParticleTick == 0 && swarmPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)swarmPlayer;
            PhantomSwarmSpawner.spawnPhantomGunnerFormation(level, serverPlayer);
            this.swarmParticleTick = 6000;
        }
        if (this.nextTick > 0) {
            return 0;
        }
        int fixedDaysInterval = (Integer)Config.COMMON.gunnerMobs.patrolIntervalDays.get();
        int randomIntervalMin = (Integer)Config.COMMON.gunnerMobs.randomIntervalMinTicks.get();
        int randomIntervalMax = (Integer)Config.COMMON.gunnerMobs.randomIntervalMaxTicks.get();
        this.nextTick = fixedDaysInterval > 0 ? (this.nextTick += fixedDaysInterval * 24000) : (this.nextTick += randomIntervalMin + random.m_188503_(randomIntervalMax - randomIntervalMin + 1));
        this.nextTick += random.m_188503_(12000);
        raidData.setNextTick(this.nextTick);
        long dayTime = level.m_46468_() / 24000L;
        int minimumDays = (Integer)Config.COMMON.gunnerMobs.minimumDaysForPatrols.get();
        if (dayTime < (long)minimumDays) {
            return 0;
        }
        int playerCount = level.m_6907_().size();
        if (playerCount < 1) {
            return 0;
        }
        Player randomPlayer = (Player)level.m_6907_().get(random.m_188503_(playerCount));
        if (randomPlayer.m_5833_() || level.m_8736_(randomPlayer.m_20183_(), 2)) {
            return 0;
        }
        BlockPos.MutableBlockPos spawnPos = randomPlayer.m_20183_().m_122032_().m_122184_((24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1), 0, (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1));
        if (!level.m_151572_(spawnPos.m_123341_() - 10, spawnPos.m_123343_() - 10, spawnPos.m_123341_() + 10, spawnPos.m_123343_() + 10)) {
            return 0;
        }
        Holder biome = level.m_204166_((BlockPos)spawnPos);
        if (biome.m_203656_(BiomeTags.f_215806_)) {
            return 0;
        }
        int patrolCount = 4 + random.m_188503_(4);
        return ModCommands.spawnPhantomSwarm(level, patrolCount, randomPlayer, spawnPos);
    }

    public static void spawnPhantomGunnerFormation(ServerLevel level, ServerPlayer player) {
        RandomSource random = level.m_213780_();
        boolean randomX = random.m_188499_();
        boolean randomZ = random.m_188499_();
        BlockPos.MutableBlockPos spawnPos = player.m_20183_().m_122032_().m_122184_((48 + random.m_188503_(48)) * (randomX ? -1 : 1), 0, (48 + random.m_188503_(48)) * (randomZ ? -1 : 1));
        Vec3 betterPos = new Vec3((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
        Vec3 spawnCenter = betterPos.m_82520_(0.0, 170.0, 0.0);
        level.m_5594_(null, BlockPos.m_274446_((Position)spawnCenter), (SoundEvent)ModSounds.EVENT_PHANTOM_SWARM.get(), SoundSource.HOSTILE, 100.0f, 1.0f);
        int numParticles = 2 + random.m_188503_(2);
        double spacing = 2.5;
        ArrayList<Vec3> formationPositions = new ArrayList<Vec3>();
        for (int i = 0; i < numParticles; ++i) {
            int row = i / 2;
            int side = i % 2 == 0 ? 1 : -1;
            double xOffset = (double)row * spacing * (double)side;
            double zOffset = (double)row * spacing;
            formationPositions.add(spawnCenter.m_82520_(xOffset, 0.0, zOffset));
        }
        for (Vec3 pos : formationPositions) {
            double speedX = (betterPos.f_82479_ - pos.f_82479_) * 0.1;
            double speedZ = (betterPos.f_82481_ - pos.f_82481_) * 0.1;
            for (ServerPlayer players : level.m_6907_()) {
                level.m_8624_(players, (ParticleOptions)((SimpleParticleType)ModParticleTypes.PHANTOM_GUNNER.get()), true, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, speedX, 0.0, speedZ, 1.0);
            }
        }
    }

    public static void spawnPhantomGunnerSwarm(ServerLevel level, ServerPlayer player) {
        RandomSource random = level.m_213780_();
        BlockPos.MutableBlockPos spawnPos = player.m_20183_().m_122032_().m_122184_((0 + random.m_188503_(175)) * (random.m_188499_() ? -1 : 1), 0, (100 + random.m_188503_(64)) * -1);
        Vec3 betterPos = new Vec3((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
        Vec3 spawnCenter = betterPos.m_82520_(0.0, 170.0, 0.0);
        int numParticles = 2 + random.m_188503_(2);
        double spacing = 10.0;
        ArrayList<Vec3> formationPositions = new ArrayList<Vec3>();
        for (int i = 0; i < numParticles; ++i) {
            int row = i / 2;
            int side = i % 2 == 0 ? 1 : -1;
            double xOffset = (double)row * spacing * (double)side;
            double zOffset = (double)row * spacing;
            formationPositions.add(spawnCenter.m_82520_(xOffset, 0.0, zOffset));
        }
        for (Vec3 pos : formationPositions) {
            double speedX = (betterPos.f_82479_ - pos.f_82479_) * 0.1;
            double speedZ = (betterPos.f_82481_ - pos.f_82481_) * 0.1;
            level.m_8624_(player, (ParticleOptions)((SimpleParticleType)ModParticleTypes.PHANTOM_GUNNER_SWARM.get()), true, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, speedX, 0.0, speedZ, 1.0);
        }
    }

    public static void spawnSecondLayerPhantomGunnerSwarm(ServerLevel level, ServerPlayer player) {
        RandomSource random = level.m_213780_();
        BlockPos.MutableBlockPos spawnPos = player.m_20183_().m_122032_().m_122184_((0 + random.m_188503_(175)) * (random.m_188499_() ? -1 : 1), 0, (100 + random.m_188503_(64)) * -1);
        Vec3 betterPos = new Vec3((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
        Vec3 spawnCenter = betterPos.m_82520_(0.0, 170.0, 0.0);
        int numParticles = 2 + random.m_188503_(2);
        double spacing = 10.0;
        ArrayList<Vec3> formationPositions = new ArrayList<Vec3>();
        for (int i = 0; i < numParticles; ++i) {
            int row = i / 2;
            int side = i % 2 == 0 ? 1 : -1;
            double xOffset = (double)row * spacing * (double)side;
            double zOffset = (double)row * spacing;
            formationPositions.add(spawnCenter.m_82520_(xOffset, 0.0, zOffset));
        }
        for (Vec3 pos : formationPositions) {
            double speedX = (betterPos.f_82479_ - pos.f_82479_) * 0.1;
            double speedZ = (betterPos.f_82481_ - pos.f_82481_) * 0.1;
            level.m_8624_(player, (ParticleOptions)((SimpleParticleType)ModParticleTypes.SECOND_LAYER_PHANTOM_GUNNER_SWARM.get()), true, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, speedX, 0.0, speedZ, 1.0);
        }
    }
}

