/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.crafting.workbench;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import ttv.migami.jeg.crafting.workbench.AbstractWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.WorkbenchIngredient;

public abstract class AbstractWorkbenchRecipeSerializer<T extends AbstractWorkbenchRecipe<?>>
implements RecipeSerializer<T> {
    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonArray input = GsonHelper.m_13933_((JsonObject)json, (String)"materials");
        for (int i = 0; i < input.size(); ++i) {
            JsonObject object = input.get(i).getAsJsonObject();
            builder.add((Object)WorkbenchIngredient.fromJson(object));
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result item entry");
        }
        JsonObject resultObject = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        ItemStack resultItem = ShapedRecipe.m_151274_((JsonObject)resultObject);
        return this.createRecipe(recipeId, resultItem, (ImmutableList<WorkbenchIngredient>)builder.build());
    }

    @Nullable
    public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ItemStack result = buffer.m_130267_();
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)((WorkbenchIngredient)Ingredient.m_43940_((FriendlyByteBuf)buffer)));
        }
        return this.createRecipe(recipeId, result, (ImmutableList<WorkbenchIngredient>)builder.build());
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130055_(((AbstractWorkbenchRecipe)recipe).getItem());
        buffer.m_130130_(((AbstractWorkbenchRecipe)recipe).getMaterials().size());
        for (WorkbenchIngredient ingredient : ((AbstractWorkbenchRecipe)recipe).getMaterials()) {
            ingredient.m_43923_(buffer);
        }
    }

    protected abstract T createRecipe(ResourceLocation var1, ItemStack var2, ImmutableList<WorkbenchIngredient> var3);
}

