/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.compat;

import com.github.exopandora.shouldersurfing.api.model.Perspective;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import ttv.migami.jeg.JustEnoughGuns;

public class ShoulderSurfingHelper {
    private static boolean disable1 = false;
    private static boolean disable2 = false;
    private static Method getShoulderInstance;
    private static Method isShoulderSurfing;
    private static Method changePerspective;

    public static boolean isShoulderSurfing() {
        if (!JustEnoughGuns.shoulderSurfingLoaded) {
            return false;
        }
        if (!disable1) {
            try {
                ShoulderSurfingHelper.init();
                Object object = getShoulderInstance.invoke(null, new Object[0]);
                return (Boolean)isShoulderSurfing.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
                JustEnoughGuns.LOGGER.error("Shoulder Surfing helper error with method isShoulderSurfing!");
                e.printStackTrace();
                disable1 = true;
            }
        } else if (!disable2) {
            try {
                ShoulderSurfingHelper.init();
                Object object = getShoulderInstance.invoke(null, new Object[0]);
                return (Boolean)isShoulderSurfing.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
                JustEnoughGuns.LOGGER.error("Shoulder Surfing helper error with method isShoulderSurfing!");
                e.printStackTrace();
                disable2 = true;
            }
        }
        return false;
    }

    public static void changePerspective(String perspective) {
        if (!JustEnoughGuns.shoulderSurfingLoaded) {
            return;
        }
        if (!disable1) {
            try {
                ShoulderSurfingHelper.init();
                Perspective pov = Perspective.SHOULDER_SURFING;
                if (perspective.toUpperCase().equals("FIRST_PERSON")) {
                    pov = Perspective.FIRST_PERSON;
                } else if (perspective.toUpperCase().equals("THIRD_PERSON_BACK")) {
                    pov = Perspective.THIRD_PERSON_BACK;
                } else if (perspective.toUpperCase().equals("THIRD_PERSON_FRONT")) {
                    pov = Perspective.THIRD_PERSON_FRONT;
                }
                Object object = getShoulderInstance.invoke(null, new Object[0]);
                changePerspective.invoke(object, pov);
            }
            catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
                JustEnoughGuns.LOGGER.error("Shoulder Surfing helper error with method changePerspective!");
                e.printStackTrace();
                disable1 = true;
            }
        } else if (!disable2) {
            try {
                ShoulderSurfingHelper.init();
                Perspective pov = Perspective.SHOULDER_SURFING;
                if (perspective.toUpperCase().equals("FIRST_PERSON")) {
                    pov = Perspective.FIRST_PERSON;
                } else if (perspective.toUpperCase().equals("THIRD_PERSON_BACK")) {
                    pov = Perspective.THIRD_PERSON_BACK;
                } else if (perspective.toUpperCase().equals("THIRD_PERSON_FRONT")) {
                    pov = Perspective.THIRD_PERSON_FRONT;
                }
                Object object = getShoulderInstance.invoke(null, new Object[0]);
                changePerspective.invoke(object, pov);
            }
            catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
                JustEnoughGuns.LOGGER.error("Shoulder Surfing helper error with method changePerspective!");
                e.printStackTrace();
                disable2 = true;
            }
        }
    }

    private static void init() {
        if (getShoulderInstance == null) {
            Class[] pArg;
            try {
                Class<?> shoulderSurfingImpl = Class.forName("com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl");
                getShoulderInstance = shoulderSurfingImpl.getDeclaredMethod("getInstance", new Class[0]);
                isShoulderSurfing = shoulderSurfingImpl.getDeclaredMethod("isShoulderSurfing", new Class[0]);
                pArg = new Class[]{Perspective.class};
                changePerspective = shoulderSurfingImpl.getDeclaredMethod("changePerspective", pArg);
            }
            catch (ClassNotFoundException | NoSuchMethodException | NullPointerException ignored) {
                if (getShoulderInstance != null) {
                    JustEnoughGuns.LOGGER.error("Shoulder Surfing helper failed to load!");
                    ignored.printStackTrace();
                }
                disable1 = true;
            }
            if (disable1) {
                try {
                    Class<?> shoulderInstance = Class.forName("com.github.exopandora.shouldersurfing.client.ShoulderInstance");
                    getShoulderInstance = shoulderInstance.getDeclaredMethod("getInstance", new Class[0]);
                    isShoulderSurfing = shoulderInstance.getDeclaredMethod("doShoulderSurfing", new Class[0]);
                    pArg = new Class[]{Perspective.class};
                    changePerspective = shoulderInstance.getDeclaredMethod("changePerspective", pArg);
                }
                catch (ClassNotFoundException | NoSuchMethodException | NullPointerException ignored) {
                    disable2 = true;
                }
            }
            if (disable1 && disable2) {
                JustEnoughGuns.LOGGER.info("Shoulder Surfing Reloaded is not installed, proceeding without helper.");
            }
        }
    }
}

