/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.render.gun.animated;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtils;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.GunRenderType;
import ttv.migami.jeg.client.SwayType;
import ttv.migami.jeg.client.handler.AimingHandler;
import ttv.migami.jeg.client.handler.GunRecoilHandler;
import ttv.migami.jeg.client.handler.GunRenderingHandler;
import ttv.migami.jeg.client.handler.ShootingHandler;
import ttv.migami.jeg.client.render.gun.animated.AnimatedGunModel;
import ttv.migami.jeg.client.render.gun.animated.model.AttachmentRenderer;
import ttv.migami.jeg.client.util.PropertyHelper;
import ttv.migami.jeg.common.GripType;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.AnimatedBowItem;
import ttv.migami.jeg.item.AnimatedGunItem;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.TelescopicScopeItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.item.attachment.IBarrel;
import ttv.migami.jeg.item.attachment.impl.Barrel;
import ttv.migami.jeg.item.attachment.impl.Scope;
import ttv.migami.jeg.item.attachment.item.PaintJobCanItem;
import ttv.migami.jeg.util.GunModifierHelper;

public class AnimatedGunRenderer
extends GeoItemRenderer<AnimatedGunItem>
implements GeoRenderer<AnimatedGunItem> {
    private static ResourceLocation customPath = null;
    private ResourceLocation oldTextureResource = null;
    private ResourceLocation oldModelResource = null;
    private static ResourceLocation oldGunTexture = null;
    private static ResourceLocation oldGunModel = null;
    private static AnimatedGunRenderer instance;
    private final AttachmentRenderer attachmentRenderer = new AttachmentRenderer(this);
    private MultiBufferSource bufferSource;
    private ItemDisplayContext renderType;
    private int sprintTransition;
    private int prevSprintTransition;
    private int sprintCooldown;
    private float sprintIntensity;
    private float immersiveRoll;
    private float fallSway;
    private float prevFallSway;

    public AnimatedGunRenderer(ResourceLocation path) {
        super((GeoModel)new AnimatedGunModel(path));
    }

    public static AnimatedGunRenderer get() {
        if (instance == null) {
            instance = new AnimatedGunRenderer(customPath);
        }
        return instance;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.updateSprinting();
        this.updateImmersiveCamera();
    }

    private void updateSprinting() {
        this.prevSprintTransition = this.sprintTransition;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91074_.m_20142_() && !((Boolean)ModSyncedDataKeys.SHOOTING.getValue((Entity)mc.f_91074_)).booleanValue() && !((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue() && !AimingHandler.get().isAiming() && this.sprintCooldown == 0) {
            if (this.sprintTransition < 5) {
                ++this.sprintTransition;
            }
        } else if (this.sprintTransition > 0) {
            --this.sprintTransition;
        }
        if (this.sprintCooldown > 0) {
            --this.sprintCooldown;
        }
    }

    private void updateImmersiveCamera() {
        this.prevFallSway = this.fallSway;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        float targetAngle = heldItem.m_41720_() instanceof GunItem || (Boolean)Config.CLIENT.display.restrictCameraRollToWeapons.get() == false ? mc.f_91074_.f_108618_.f_108566_ : 0.0f;
        float speed = mc.f_91074_.f_108618_.f_108566_ != 0.0f ? 0.1f : 0.15f;
        this.immersiveRoll = Mth.m_14179_((float)speed, (float)this.immersiveRoll, (float)targetAngle);
        float deltaY = (float)Mth.m_14008_((double)(mc.f_91074_.f_19855_ - mc.f_91074_.m_20186_()), (double)-1.0, (double)1.0);
        deltaY = (float)((double)deltaY * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        deltaY = (float)((double)deltaY * (1.0 - (double)(Mth.m_14154_((float)mc.f_91074_.m_146909_()) / 90.0f)));
        this.fallSway = Mth.m_14121_((float)this.fallSway, (float)(deltaY * 60.0f * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()), (float)10.0f);
        float intensity = mc.f_91074_.m_20142_() ? 0.75f : 1.0f;
        this.sprintIntensity = Mth.m_14121_((float)this.sprintIntensity, (float)intensity, (float)0.1f);
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        this.sprintTransition = 0;
        this.sprintCooldown = 20;
    }

    private ResourceLocation getValidTexture(ResourceLocation texture, ItemStack stack) {
        Minecraft client = Minecraft.m_91087_();
        Optional resource = client.m_91098_().m_213713_(texture);
        if (resource.isPresent()) {
            return texture;
        }
        if (stack.m_41720_() instanceof GunItem) {
            return new ResourceLocation("jeg", "textures/animated/gun/" + stack.m_41720_() + ".png");
        }
        return new ResourceLocation("jeg", "textures/animated/attachment/" + stack.m_41720_() + ".png");
    }

    private ResourceLocation getValidModel(ResourceLocation model, ItemStack stack) {
        Minecraft client = Minecraft.m_91087_();
        Optional resource = client.m_91098_().m_213713_(model);
        if (resource.isPresent()) {
            return model;
        }
        if (stack.m_41720_() instanceof GunItem) {
            return new ResourceLocation("jeg", "geo/item/gun/" + stack.m_41720_() + ".geo.json");
        }
        return new ResourceLocation("jeg", "geo/item/attachment/" + stack.m_41720_() + ".geo.json");
    }

    private void updateGunSkin(ItemStack stack) {
        ResourceLocation newGunModel;
        Item item;
        ResourceLocation newGunTexture;
        Item item2;
        if (stack.m_41782_() && (item2 = Gun.getAttachment(IAttachment.Type.PAINT_JOB, stack).m_41720_()) instanceof PaintJobCanItem) {
            PaintJobCanItem paintJobCanItem = (PaintJobCanItem)item2;
            newGunTexture = new ResourceLocation("jeg", "textures/animated/gun/paintjob/" + paintJobCanItem.getPaintJob() + "/" + stack.m_41720_() + ".png");
        } else {
            newGunTexture = new ResourceLocation("jeg", "textures/animated/gun/" + stack.m_41720_() + ".png");
        }
        newGunTexture = this.getValidTexture(newGunTexture, stack);
        if (!newGunTexture.equals((Object)oldGunTexture)) {
            oldGunTexture = newGunTexture;
            AnimatedGunModel animaModel = (AnimatedGunModel)this.getGeoModel();
            animaModel.setCurrentTexture(oldGunTexture);
        }
        if (stack.m_41782_() && (item = Gun.getAttachment(IAttachment.Type.PAINT_JOB, stack).m_41720_()) instanceof PaintJobCanItem) {
            PaintJobCanItem paintJobCanItem = (PaintJobCanItem)item;
            newGunModel = new ResourceLocation("jeg", "geo/item/gun/paintjob/" + paintJobCanItem.getPaintJob() + "/" + stack.m_41720_() + ".geo.json");
        } else {
            newGunModel = new ResourceLocation("jeg", "geo/item/gun/" + stack.m_41720_() + ".geo.json");
        }
        newGunModel = this.getValidModel(newGunModel, stack);
        if (!newGunModel.equals((Object)oldGunModel)) {
            oldGunModel = newGunModel;
            AnimatedGunModel animaModel = (AnimatedGunModel)this.getGeoModel();
            animaModel.setCurrentModel(oldGunModel);
        }
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int blockLight;
        this.bufferSource = bufferSource;
        this.renderType = transformType;
        if (stack.m_150930_(Items.f_41852_)) {
            return;
        }
        if (!(this.renderType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType.equals((Object)ItemDisplayContext.FIXED) || transformType.equals((Object)ItemDisplayContext.GROUND) || stack.m_150930_((Item)ModItems.FINGER_GUN.get()))) {
            poseStack.m_85849_();
            poseStack.m_85836_();
            Minecraft mc = Minecraft.m_91087_();
            GunRenderingHandler.get().renderWeapon((LivingEntity)mc.f_91074_, stack, transformType, poseStack, bufferSource, packedLight, Minecraft.m_91087_().m_91297_());
            poseStack.m_85849_();
            poseStack.m_85836_();
            return;
        }
        if (AimingHandler.get().isAiming() && this.renderPerspective == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && (Gun.getAttachment(IAttachment.Type.SCOPE, this.getCurrentItemStack()).m_41720_() instanceof TelescopicScopeItem || Gun.getAttachment(IAttachment.Type.SCOPE, this.getCurrentItemStack()).m_150930_(Items.f_151059_))) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? player.m_7655_() == InteractionHand.MAIN_HAND : player.m_7655_() == InteractionHand.OFF_HAND;
        HumanoidArm hand = right ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
        ItemStack overrideModel = ItemStack.f_41583_;
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("Model", 10)) {
            overrideModel = ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_("Model"));
        }
        LocalPlayer localPlayer = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(overrideModel.m_41619_() ? stack : overrideModel, player.m_9236_(), (LivingEntity)player, 0);
        float scaleX = model.m_7442_().f_111790_.f_111757_.x();
        float scaleY = model.m_7442_().f_111790_.f_111757_.y();
        float scaleZ = model.m_7442_().f_111790_.f_111757_.z();
        float translateX = model.m_7442_().f_111790_.f_111756_.x();
        float translateY = model.m_7442_().f_111790_.f_111756_.y();
        float translateZ = model.m_7442_().f_111790_.f_111756_.z();
        this.updateGunSkin(stack);
        if (stack.m_41720_() instanceof AnimatedGunItem && this.renderType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
            this.applyBobbingTransforms(poseStack, Minecraft.m_91087_().getPartialTick());
            this.immersiveRoll = GunRenderingHandler.get().immersiveRoll;
            this.fallSway = GunRenderingHandler.get().fallSway / 2.0f;
            this.prevFallSway = GunRenderingHandler.get().prevFallSway / 2.0f;
            int offset = right ? 1 : -1;
            this.applyRecoilTransforms(poseStack, stack, modifiedGun);
            this.applyAimingTransforms(poseStack, stack, modifiedGun, translateX, translateY, translateZ, offset);
            this.applySwayTransforms(poseStack, modifiedGun, localPlayer, translateX, translateY, translateZ, Minecraft.m_91087_().getPartialTick());
            if (stack.m_41720_() instanceof AnimatedBowItem) {
                poseStack.m_85837_(-0.5, 0.5, -0.1);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
            }
            if (AimingHandler.get().getNormalisedAdsProgress() > 0.0 && modifiedGun.canAimDownSight()) {
                float side;
                double xOffset = translateX;
                double yOffset = translateY;
                double zOffset = translateZ;
                xOffset -= 0.5 * (double)scaleX;
                yOffset -= 0.5 * (double)scaleY;
                zOffset -= 0.5 * (double)scaleZ;
                Vec3 gunOrigin = PropertyHelper.getModelOrigin(stack, PropertyHelper.GUN_DEFAULT_ORIGIN);
                xOffset += gunOrigin.f_82479_ * 0.0625 * (double)scaleX;
                yOffset += gunOrigin.f_82480_ * 0.0625 * (double)scaleY;
                zOffset += gunOrigin.f_82481_ * 0.0625 * (double)scaleZ;
                Scope scope = Gun.getScope(stack);
                if (modifiedGun.canAttachType(IAttachment.Type.SCOPE) && scope != null) {
                    Vec3 scopePosition = PropertyHelper.getAttachmentPosition(stack, modifiedGun, IAttachment.Type.SCOPE).m_82546_(gunOrigin);
                    xOffset += scopePosition.f_82479_ * 0.0625 * (double)scaleX;
                    yOffset += scopePosition.f_82480_ * 0.0625 * (double)scaleY;
                    zOffset += scopePosition.f_82481_ * 0.0625 * (double)scaleZ;
                    ItemStack scopeStack = Gun.getScopeStack(stack);
                    Vec3 scopeOrigin = PropertyHelper.getModelOrigin(scopeStack, PropertyHelper.ATTACHMENT_DEFAULT_ORIGIN);
                    Vec3 scopeCamera = PropertyHelper.getScopeCamera(scopeStack).m_82546_(scopeOrigin);
                    Vec3 scopeScale = PropertyHelper.getAttachmentScale(stack, modifiedGun, IAttachment.Type.SCOPE);
                    xOffset += scopeCamera.f_82479_ * 0.0625 * (double)scaleX * scopeScale.f_82479_;
                    yOffset += (scopeCamera.f_82480_ * 0.0625 * (double)scaleY + 0.54) * scopeScale.f_82480_;
                    zOffset += (scopeCamera.f_82481_ * 0.0625 * (double)scaleZ - 0.16) * scopeScale.f_82481_;
                    if (scopeStack.m_150930_(Items.f_151059_)) {
                        xOffset += scopeCamera.f_82479_ * 0.0625 * (double)scaleX * scopeScale.f_82479_;
                        yOffset += (scopeCamera.f_82480_ * 0.0625 * (double)scaleY + 0.075) * scopeScale.f_82480_;
                        zOffset += (scopeCamera.f_82481_ * 0.0625 * (double)scaleZ + 0.6) * scopeScale.f_82481_;
                    }
                } else {
                    Vec3 ironSightCamera = PropertyHelper.getIronSightCamera(stack, modifiedGun, gunOrigin).m_82546_(gunOrigin);
                    xOffset += ironSightCamera.f_82479_ * 0.0625 * (double)scaleX;
                    yOffset += ironSightCamera.f_82480_ * 0.0625 * (double)scaleY + 0.6059;
                    zOffset += ironSightCamera.f_82481_ * 0.0625 * (double)scaleZ - 0.16;
                    if (PropertyHelper.isLegacyIronSight(stack)) {
                        zOffset += 0.72;
                    }
                }
                float f = side = right ? 1.0f : -1.0f;
                if (Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT && player.m_21206_().m_41720_() instanceof ShieldItem) {
                    side = 1.0f;
                }
                if (Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.LEFT && player.m_21206_().m_41720_() instanceof ShieldItem) {
                    side = -1.0f;
                }
                side = 1.0f;
                double time = AimingHandler.get().getNormalisedAdsProgress();
                double transition = PropertyHelper.getSightAnimations(stack, modifiedGun).getSightCurve().apply(time);
                if (stack.m_41720_() instanceof AnimatedBowItem) {
                    poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(45.0 * transition)));
                    poseStack.m_85837_(0.508 * transition, -0.6 * transition, 0.0);
                }
                poseStack.m_85837_(-0.56 * (double)side * transition, 0.52 * transition, 0.72 * transition);
                poseStack.m_85837_(-xOffset * (double)side * transition, -yOffset * transition, -zOffset * transition);
            }
        }
        if (transformType.m_269069_() && ShootingHandler.get().isShooting() && !GunModifierHelper.isSilencedFire(stack)) {
            this.renderMuzzleFlash((LivingEntity)Minecraft.m_91087_().f_91074_, poseStack, bufferSource, stack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, Minecraft.m_91087_().getPartialTick());
        }
        int n = blockLight = player.m_6060_() ? 15 : player.m_9236_().m_45517_(LightLayer.BLOCK, BlockPos.m_274446_((Position)player.m_20299_(Minecraft.m_91087_().getPartialTick())));
        if (ShootingHandler.get().isShooting() && !GunModifierHelper.isSilencedFire(stack) && transformType.m_269069_()) {
            blockLight += GunRenderingHandler.entityIdForMuzzleFlash.contains(player.m_19879_()) ? 3 : 0;
        }
        blockLight = Math.min(blockLight, 15);
        packedLight = this.renderType == ItemDisplayContext.GUI ? 0xF000F0 : LightTexture.m_109885_((int)blockLight, (int)player.m_9236_().m_45517_(LightLayer.SKY, BlockPos.m_274446_((Position)player.m_20299_(Minecraft.m_91087_().getPartialTick()))));
        super.m_108829_(stack, transformType, poseStack, bufferSource, packedLight, packedOverlay);
    }

    public void renderRecursively(PoseStack poseStack, AnimatedGunItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.renderPerspective != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && this.renderPerspective != ItemDisplayContext.FIXED && this.renderPerspective != ItemDisplayContext.GROUND && !this.currentItemStack.m_150930_((Item)ModItems.FINGER_GUN.get())) {
            return;
        }
        if (AimingHandler.get().isAiming() && this.renderPerspective == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && (Gun.getAttachment(IAttachment.Type.SCOPE, this.getCurrentItemStack()).m_41720_() instanceof TelescopicScopeItem || Gun.getAttachment(IAttachment.Type.SCOPE, this.getCurrentItemStack()).m_150930_(Items.f_151059_))) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        boolean renderArms = false;
        VertexConsumer buffer1 = this.bufferSource.m_6299_(renderType);
        poseStack.m_85836_();
        if (this.currentItemStack.m_41720_() == ModItems.SERVICE_RIFLE.get()) {
            switch (bone.getName()) {
                case "railing": {
                    bone.setHidden(Gun.getScope(this.currentItemStack) == null);
                    break;
                }
                case "stock_iron_sight": {
                    bone.setHidden(Gun.getScope(this.currentItemStack) != null || Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() == ModItems.TACTICAL_STOCK.get());
                    break;
                }
                case "modified_iron_sight": {
                    bone.setHidden(Gun.getScope(this.currentItemStack) != null || Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.TACTICAL_STOCK.get());
                    break;
                }
                case "weighted_handguard": {
                    bone.setHidden(!Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41619_() && Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.WEIGHTED_STOCK.get());
                    break;
                }
                case "tactical_handguard": {
                    bone.setHidden(Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.TACTICAL_STOCK.get());
                    break;
                }
                case "light_handguard": {
                    bone.setHidden(Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.LIGHT_STOCK.get());
                }
            }
        }
        if (animatable instanceof AnimatedBowItem && this.currentItemStack.m_41783_() != null && bone.getName().matches("arrow")) {
            if (this.renderPerspective.equals((Object)ItemDisplayContext.FIRST_PERSON_RIGHT_HAND)) {
                bone.setHidden(this.currentItemStack.m_41783_().m_128451_("AmmoCount") <= 0);
            } else {
                bone.setHidden(true);
            }
        }
        if (bone.getName().matches("glow") || bone.getName().matches("glow_2") || bone.getName().matches("glow_3")) {
            packedLight = 0xF000F0;
        }
        if (this.currentItemStack.m_41783_() != null) {
            int ammoCount = this.currentItemStack.m_41783_().m_128451_("AmmoCount");
            Map<String, Integer> boneAmmoThresholds = Map.of("bullet_1", 1, "bullet_2", 2, "bullet_3", 3, "bullet_4", 4, "bullet_5", 5, "bullet_6", 6, "bullet_7", 7);
            boneAmmoThresholds.forEach((boneName, threshold) -> {
                if (bone.getName().matches((String)boneName)) {
                    bone.setHidden(ammoCount < threshold);
                }
            });
        }
        if (bone.getName().matches("flashlight_glow") && Gun.hasAttachmentEquipped(this.currentItemStack, IAttachment.Type.SPECIAL) && Gun.getAttachment(IAttachment.Type.SPECIAL, this.currentItemStack).m_41720_() == ModItems.FLASHLIGHT.get()) {
            String flashlight = Gun.getAttachment(IAttachment.Type.SPECIAL, this.currentItemStack);
            if (flashlight.m_41783_() != null && flashlight.m_41783_().m_128471_("Powered")) {
                bone.setHidden(false);
            } else {
                bone.setHidden(true);
            }
        }
        switch (bone.getName()) {
            case "left_arm": 
            case "right_arm": 
            case "fake_left_arm": 
            case "fake_right_arm": {
                bone.setHidden(true);
                bone.setChildrenHidden(false);
                renderArms = true;
                break;
            }
            case "iron_sight": {
                bone.setHidden(Gun.getScope(this.currentItemStack) != null);
                break;
            }
            case "hidden_iron_sight": {
                bone.setHidden(Gun.getScope(this.currentItemStack) == null);
                break;
            }
            case "makeshift_stock": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.MAKESHIFT_STOCK.get());
                break;
            }
            case "light_stock": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.LIGHT_STOCK.get());
                break;
            }
            case "tactical_stock": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.TACTICAL_STOCK.get());
                break;
            }
            case "weighted_stock": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.WEIGHTED_STOCK.get());
                break;
            }
            case "silencer": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.BARREL, this.currentItemStack).m_41720_() != ModItems.SILENCER.get());
                break;
            }
            case "light_grip": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.UNDER_BARREL, this.currentItemStack).m_41720_() != ModItems.LIGHT_GRIP.get());
                break;
            }
            case "vertical_grip": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.UNDER_BARREL, this.currentItemStack).m_41720_() != ModItems.VERTICAL_GRIP.get());
                break;
            }
            case "angled_grip": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.UNDER_BARREL, this.currentItemStack).m_41720_() != ModItems.ANGLED_GRIP.get());
                break;
            }
            case "default_mag": 
            case "default_mag_2": {
                bone.setHidden(!Gun.getAttachment(IAttachment.Type.MAGAZINE, this.currentItemStack).m_41619_());
                break;
            }
            case "extended_mag": 
            case "extended_mag_2": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.MAGAZINE, this.currentItemStack).m_41720_() != ModItems.EXTENDED_MAG.get());
                break;
            }
            case "drum_mag": 
            case "drum_mag_2": {
                bone.setHidden(Gun.getAttachment(IAttachment.Type.MAGAZINE, this.currentItemStack).m_41720_() != ModItems.DRUM_MAG.get());
            }
        }
        if (this.renderType != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            renderArms = animatable.m_7968_().m_41720_() == ModItems.FINGER_GUN.get() ? this.renderType != ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : false;
        }
        if (renderArms) {
            PlayerRenderer playerEntityRenderer = (PlayerRenderer)client.m_91290_().m_114382_((Entity)client.f_91074_);
            PlayerModel playerEntityModel = (PlayerModel)playerEntityRenderer.m_7200_();
            RenderUtils.translateMatrixToBone((PoseStack)poseStack, (CoreGeoBone)bone);
            RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
            RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
            RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
            RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
            ResourceLocation playerSkin = client.f_91074_.m_108560_();
            VertexConsumer arm = this.bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)playerSkin));
            VertexConsumer sleeve = this.bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin));
            LocalPlayer player = client.f_91074_;
            Gun modifiedGun = ((GunItem)this.currentItemStack.m_41720_()).getModifiedGun(this.currentItemStack);
            long id = GeoItem.getId((ItemStack)player.m_21205_());
            AnimationController animationController = (AnimationController)animatable.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
            if (bone.getName().equals("left_arm") || bone.getName().equals("fake_left_arm")) {
                boolean isOneHanded = modifiedGun.getGeneral().getGripType().equals(GripType.ONE_HANDED);
                boolean isHoldingShield = player.m_21206_().m_41720_() instanceof ShieldItem;
                poseStack.m_85841_(0.67f, 0.8f, 0.67f);
                poseStack.m_85837_(-0.25, -0.1, 0.1625);
                playerEntityModel.f_102812_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                playerEntityModel.f_102812_.m_171327_(0.0f, 0.0f, 0.0f);
                playerEntityModel.f_102812_.m_104306_(poseStack, arm, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                playerEntityModel.f_103374_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                playerEntityModel.f_103374_.m_171327_(0.0f, 0.0f, 0.0f);
                playerEntityModel.f_103374_.m_104306_(poseStack, sleeve, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            } else if (bone.getName().equals("right_arm") || bone.getName().equals("fake_right_arm")) {
                poseStack.m_85841_(0.67f, 0.8f, 0.67f);
                poseStack.m_85837_(0.25, -0.1, 0.1625);
                playerEntityModel.f_102811_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                playerEntityModel.f_102811_.m_171327_(0.0f, 0.0f, 0.0f);
                playerEntityModel.f_102811_.m_104306_(poseStack, arm, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                playerEntityModel.f_103375_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                playerEntityModel.f_103375_.m_171327_(0.0f, 0.0f, 0.0f);
                playerEntityModel.f_103375_.m_104306_(poseStack, sleeve, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (bone.getName().matches("attachment_bone")) {
            this.renderAttachments(bone, this.currentItemStack, poseStack, renderType, buffer, packedLight, Minecraft.m_91087_().getPartialTick(), packedOverlay);
        }
        super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer1, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    private void applyRecoilTransforms(PoseStack poseStack, ItemStack item, Gun gun) {
        double recoilNormal = GunRecoilHandler.get().getGunRecoilNormal();
        if (Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.SCOPE)) {
            recoilNormal -= recoilNormal * (0.5 * AimingHandler.get().getNormalisedAdsProgress());
        }
        float kickReduction = 1.0f - GunModifierHelper.getKickReduction(item);
        float recoilReduction = 1.0f - GunModifierHelper.getRecoilModifier(item);
        double kick = (double)gun.getGeneral().getRecoilKick() * 0.0625 * recoilNormal * GunRecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilLift = (float)((double)gun.getGeneral().getRecoilAngle() * recoilNormal) * (float)GunRecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilSwayAmount = (float)(2.0 + 1.0 * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float recoilSway = (float)((double)(GunRecoilHandler.get().getGunRecoilRandom() * recoilSwayAmount - recoilSwayAmount / 2.0f) * recoilNormal);
        poseStack.m_85837_(0.0, 0.0, kick * (double)kickReduction);
        poseStack.m_85837_(0.0, 0.0, 0.15);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(recoilSway * recoilReduction / 5.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(recoilSway * recoilReduction / 5.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(recoilLift * recoilReduction / 5.0f));
        poseStack.m_85837_(0.0, 0.0, -0.15);
    }

    private void applyBobbingTransforms(PoseStack poseStack, float partialTicks) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)mc.f_91066_.m_231830_().m_231551_()).booleanValue() && (entity = mc.m_91288_()) instanceof Player) {
            Player player = (Player)entity;
            float deltaDistanceWalked = player.f_19787_ - player.f_19867_;
            float distanceWalked = -(player.f_19787_ + deltaDistanceWalked * partialTicks);
            float bobbing = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * 5.0f)));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f)));
            poseStack.m_85837_((double)(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 0.5f)), (double)(-(-Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI)) * bobbing))), 0.0);
            bobbing = (float)((double)bobbing * (player.m_20142_() ? 8.0 : 4.0));
            bobbing = (float)((double)bobbing * (Double)Config.CLIENT.display.bobbingIntensity.get());
            double invertZoomProgress = 1.0 - AimingHandler.get().getNormalisedAdsProgress() * (double)this.sprintIntensity;
            if (!AimingHandler.get().isAiming()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * -2.0f * (float)invertZoomProgress));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f * (float)invertZoomProgress));
            }
        }
    }

    private void applyAimingTransforms(PoseStack poseStack, ItemStack stack, Gun modifiedGun, float x, float y, float z, int offset) {
        poseStack.m_252880_(x * (float)offset, y, z);
        poseStack.m_85837_(0.0, -0.25, 0.25);
        float aiming = (float)Math.sin(Math.toRadians(AimingHandler.get().getNormalisedAdsProgress() * 180.0));
        aiming = PropertyHelper.getSightAnimations(stack, modifiedGun).getAimTransformCurve().apply(aiming / 2.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(aiming * 10.0f * (float)offset));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(aiming * 8.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(aiming * 8.0f * (float)offset));
        poseStack.m_85837_(0.0, 0.25, -0.25);
        poseStack.m_252880_(-x * (float)offset, -y, -z);
    }

    private void applySwayTransforms(PoseStack poseStack, Gun modifiedGun, LocalPlayer player, float x, float y, float z, float partialTicks) {
        if (((Boolean)Config.CLIENT.display.weaponSway.get()).booleanValue() && player != null) {
            poseStack.m_252880_(x, y, z);
            double zOffset = modifiedGun.getGeneral().getGripType().getHeldAnimation().getFallSwayZOffset();
            poseStack.m_85837_(0.0, -0.25, zOffset);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)this.prevFallSway, (float)this.fallSway)));
            poseStack.m_85837_(0.0, 0.25, -zOffset);
            float bobPitch = Mth.m_14189_((float)partialTicks, (float)player.f_108588_, (float)player.f_108586_);
            float headPitch = Mth.m_14189_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_());
            float swayPitch = headPitch - bobPitch;
            swayPitch = (float)((double)swayPitch * (1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress()));
            poseStack.m_252781_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getPitchRotation().m_252977_(swayPitch * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue() / 2.0f));
            float bobYaw = Mth.m_14189_((float)partialTicks, (float)player.f_108587_, (float)player.f_108585_);
            float headYaw = Mth.m_14189_((float)partialTicks, (float)player.f_20886_, (float)player.f_20885_);
            float swayYaw = headYaw - bobYaw;
            swayYaw = (float)((double)swayYaw * (1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress()));
            poseStack.m_252781_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getYawRotation().m_252977_(swayYaw * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue() / 2.0f));
            poseStack.m_252880_(-x, -y, -z);
        }
    }

    private void applySprintingTransforms(Gun modifiedGun, HumanoidArm hand, PoseStack poseStack, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)Config.CLIENT.display.sprintAnimation.get()).booleanValue() && modifiedGun.getGeneral().getGripType().getHeldAnimation().canApplySprintingAnimation()) {
            float leftHanded = hand == HumanoidArm.LEFT ? -1.0f : 1.0f;
            float transition = ((float)this.prevSprintTransition + (float)(this.sprintTransition - this.prevSprintTransition) * partialTicks) / 5.0f;
            transition = (float)Math.sin((double)transition * Math.PI / 2.0);
            poseStack.m_85837_(-0.1 * (double)transition, -0.3 * (double)transition, 0.9 * (double)transition);
            if (Gun.getAttachment(IAttachment.Type.BARREL, mc.f_91074_.m_21205_()).m_41720_() instanceof SwordItem) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(15.0f * transition));
            } else if (modifiedGun.getGeneral().getGripType().equals(GripType.TWO_HANDED)) {
                poseStack.m_85837_(-0.25 * (double)leftHanded * (double)transition, -0.1 * (double)transition, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f * leftHanded * transition));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-25.0f * transition));
            }
        }
    }

    private void renderAttachments(GeoBone bone, ItemStack stack, PoseStack poseStack, RenderType renderType, VertexConsumer renderTypeBuffer, int light, float partialTicks, int packedOverlay) {
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
            CompoundTag gunTag = stack.m_41784_();
            CompoundTag attachments = gunTag.m_128469_("Attachments");
            for (String tagKey : attachments.m_128431_()) {
                ResourceLocation newTextureResource;
                Item item2;
                ItemStack attachmentStack;
                IAttachment.Type type = IAttachment.Type.byTagKey(tagKey);
                if (type == null || !modifiedGun.canAttachType(type) || (attachmentStack = Gun.getAttachment(type, stack)).m_41619_()) continue;
                poseStack.m_85836_();
                Vec3 origin = PropertyHelper.getModelOrigin(attachmentStack, PropertyHelper.ATTACHMENT_DEFAULT_ORIGIN);
                poseStack.m_85837_(-origin.f_82479_ * 0.0625, -origin.f_82480_ * 0.0625, -origin.f_82481_ * 0.0625);
                Vec3 gunOrigin = PropertyHelper.getModelOrigin(stack, PropertyHelper.GUN_DEFAULT_ORIGIN);
                poseStack.m_85837_(gunOrigin.f_82479_ * 0.0625, gunOrigin.f_82480_ * 0.0625, gunOrigin.f_82481_ * 0.0625);
                Vec3 translation = PropertyHelper.getAttachmentPosition(stack, modifiedGun, type).m_82546_(gunOrigin);
                poseStack.m_85837_(translation.f_82479_ * 0.0625, translation.f_82480_ * 0.0625, translation.f_82481_ * 0.0625);
                Vec3 scale = PropertyHelper.getAttachmentScale(stack, modifiedGun, type);
                Vec3 center = origin.m_82492_(8.0, 8.0, 8.0).m_82490_(0.0625);
                poseStack.m_85837_(center.f_82479_, center.f_82480_, center.f_82481_);
                poseStack.m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
                poseStack.m_85837_(-center.f_82479_, -center.f_82480_, -center.f_82481_);
                if (stack.m_41782_() && (item2 = Gun.getAttachment(IAttachment.Type.PAINT_JOB, stack).m_41720_()) instanceof PaintJobCanItem) {
                    PaintJobCanItem paintJobCanItem = (PaintJobCanItem)item2;
                    newTextureResource = new ResourceLocation("jeg", "textures/animated/attachment/paintjob/" + paintJobCanItem.getPaintJob() + "/" + attachmentStack.m_41720_() + ".png");
                } else {
                    newTextureResource = new ResourceLocation("jeg", "textures/animated/attachment/" + attachmentStack.m_41720_() + ".png");
                }
                newTextureResource = this.getValidTexture(newTextureResource, attachmentStack);
                if (!newTextureResource.equals((Object)this.oldTextureResource)) {
                    // empty if block
                }
                this.attachmentRenderer.updateTexture(newTextureResource);
                this.oldTextureResource = newTextureResource;
                this.attachmentRenderer.updateAttachment(attachmentStack);
                this.attachmentRenderer.renderForBone(poseStack, (AnimatedGunItem)this.animatable, bone, renderType, this.bufferSource, renderTypeBuffer, partialTicks, light, packedOverlay);
                poseStack.m_85849_();
            }
        }
    }

    private void renderMuzzleFlash(@Nullable LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, ItemStack weapon, ItemDisplayContext display, float partialTicks) {
        float randomValue;
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        if (modifiedGun.getDisplay().getFlash() == null) {
            return;
        }
        if (display != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && display != ItemDisplayContext.THIRD_PERSON_RIGHT_HAND && display != ItemDisplayContext.FIRST_PERSON_LEFT_HAND && display != ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            return;
        }
        if (entity == null || !GunRenderingHandler.entityIdForMuzzleFlash.contains(entity.m_19879_())) {
            return;
        }
        this.drawMuzzleFlash(weapon, modifiedGun, randomValue, (randomValue = GunRenderingHandler.entityIdToRandomValue.get(entity.m_19879_()).floatValue()) >= 0.5f, poseStack, buffer, partialTicks, display);
    }

    private void drawMuzzleFlash(ItemStack weapon, Gun modifiedGun, float random, boolean flip, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, ItemDisplayContext displayContext) {
        float maxU;
        Item item;
        if (!PropertyHelper.hasMuzzleFlash(weapon, modifiedGun)) {
            return;
        }
        poseStack.m_85836_();
        Vec3 weaponOrigin = PropertyHelper.getModelOrigin(weapon, PropertyHelper.GUN_DEFAULT_ORIGIN);
        Vec3 flashPosition = PropertyHelper.getMuzzleFlashPosition(weapon, modifiedGun).m_82546_(weaponOrigin);
        poseStack.m_85837_(weaponOrigin.f_82479_ * 0.0625, weaponOrigin.f_82480_ * 0.0625, weaponOrigin.f_82481_ * 0.0625);
        poseStack.m_85837_(flashPosition.f_82479_ * 0.0625 + 0.5, flashPosition.f_82480_ * 0.0625 + 1.025, flashPosition.f_82481_ * 0.0625 + 0.525);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        ItemStack barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, weapon);
        if (!barrelStack.m_41619_() && (item = barrelStack.m_41720_()) instanceof IBarrel) {
            IBarrel barrel = (IBarrel)item;
            if (!PropertyHelper.isUsingBarrelMuzzleFlash(barrelStack)) {
                Vec3 scale = PropertyHelper.getAttachmentScale(weapon, modifiedGun, IAttachment.Type.BARREL);
                double length = ((Barrel)barrel.getProperties()).getLength();
                poseStack.m_85837_(0.0, 0.0, -length * 0.0625 * scale.f_82481_);
            }
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(360.0f * random));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(flip ? 180.0f : 0.0f));
        Vec3 flashScale = PropertyHelper.getMuzzleFlashScale(weapon, modifiedGun);
        float scaleX = (float)flashScale.f_82479_ / 2.0f - (float)flashScale.f_82479_ / 2.0f * (1.0f - partialTicks);
        float scaleY = (float)flashScale.f_82480_ / 2.0f - (float)flashScale.f_82480_ / 2.0f * (1.0f - partialTicks);
        float scale = 1.5f;
        poseStack.m_85841_(scaleX * scale, scaleY * scale, 1.0f);
        float scaleModifier = (float)GunModifierHelper.getMuzzleFlashScale(weapon, 1.0);
        poseStack.m_85841_(scaleModifier, scaleModifier, 1.0f);
        poseStack.m_85837_(-0.5, -0.5, 0.0);
        float minU = weapon.m_41793_() ? 0.5f : 0.0f;
        float f = maxU = weapon.m_41793_() ? 1.0f : 0.5f;
        if (weapon.m_41720_() == ModItems.SUBSONIC_RIFLE.get() || weapon.m_41720_() == ModItems.FLAMETHROWER.get() || weapon.m_41720_() == ModItems.SUPERSONIC_SHOTGUN.get() || weapon.m_41720_() == ModItems.HYPERSONIC_CANNON.get() || weapon.m_41720_() == ModItems.SOULHUNTER_MK2.get() || weapon.m_41720_() == ModItems.BLOSSOM_RIFLE.get() || weapon.m_41720_() == ModItems.HOLY_SHOTGUN.get()) {
            minU = 0.5f;
            maxU = 1.0f;
        }
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer builder = buffer.m_6299_(GunRenderType.getMuzzleFlash());
        Minecraft mc = Minecraft.m_91087_();
        if (weapon.getEnchantmentLevel((Enchantment)ModEnchantments.ATLANTIC_SHOOTER.get()) != 0 && mc.f_91074_ != null && mc.f_91074_.m_5842_()) {
            builder = buffer.m_6299_(GunRenderType.getBubbleFlash());
            minU = 0.0f;
            maxU = 1.0f;
        }
        builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 0.0f).m_85969_(0xF000F0).m_5752_();
        poseStack.m_85849_();
    }
}

