/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.handler;

import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationController;
import ttv.migami.jeg.client.KeyBinds;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.event.GunReloadEvent;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.AnimatedGunItem;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageFirstPersonReload;
import ttv.migami.jeg.network.message.C2SMessageLeftOverAmmo;
import ttv.migami.jeg.network.message.C2SMessageReload;
import ttv.migami.jeg.network.message.C2SMessageUnload;
import ttv.migami.jeg.util.GunModifierHelper;

public class ReloadHandler {
    private static ReloadHandler instance;
    private int startReloadTick;
    private int reloadTimer;
    private int prevReloadTimer;
    private int reloadingSlot;

    public static ReloadHandler get() {
        if (instance == null) {
            instance = new ReloadHandler();
        }
        return instance;
    }

    private ReloadHandler() {
    }

    public static void stopReloadAnimation() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.m_21205_();
        Item item = itemStack.m_41720_();
        if (item instanceof AnimatedGunItem) {
            AnimatedGunItem gunItem = (AnimatedGunItem)item;
            long id = GeoItem.getId((ItemStack)player.m_21205_());
            AnimationController animationController = (AnimationController)gunItem.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
            animationController.tryTriggerAnimation("reload_stop");
            animationController.forceAnimationReset();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.prevReloadTimer = this.reloadTimer;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ItemStack stack = player.m_21205_();
            CompoundTag tag = stack.m_41783_();
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageLeftOverAmmo());
            if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                CameraType cameraType;
                if (this.reloadingSlot != player.m_150109_().f_35977_) {
                    this.setReloading(false);
                }
                if ((cameraType = Minecraft.m_91087_().f_91066_.m_92176_()).m_90612_()) {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageFirstPersonReload(true));
                } else {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageFirstPersonReload(false));
                }
            }
            this.updateReloadTimer((Player)player);
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        CompoundTag tag = stack.m_41783_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(stack);
            if (KeyBinds.KEY_RELOAD.m_90857_() && event.getAction() == 1) {
                if (tag != null) {
                    tag.m_128379_("IsReloading", true);
                }
                this.setReloading(true);
            }
            if (KeyBinds.KEY_UNLOAD.m_90859_() && event.getAction() == 1) {
                if (tag != null) {
                    tag.m_128379_("IsReloading", false);
                }
                this.setReloading(false);
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageUnload());
            }
            if (KeyBinds.KEY_MELEE.m_90859_() && event.getAction() == 1) {
                if (tag != null) {
                    tag.m_128379_("IsReloading", false);
                }
                this.setReloading(false);
            }
        }
    }

    public void setReloading(boolean reloading) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ItemStack stack = player.m_21205_();
            CompoundTag tag = stack.m_41783_();
            if (reloading) {
                if (stack.m_41720_() instanceof GunItem && tag != null && !tag.m_128425_("IgnoreAmmo", 1)) {
                    Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
                    if (tag.m_128451_("AmmoCount") >= GunModifierHelper.getModifiedAmmoCapacity(stack, gun)) {
                        return;
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((Player)player, stack))) {
                        return;
                    }
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)true);
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(true));
                    this.reloadingSlot = player.m_150109_().f_35977_;
                    MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((Player)player, stack));
                }
            } else {
                ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false));
                this.reloadingSlot = -1;
            }
        }
    }

    private void updateReloadTimer(Player player) {
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
            if (this.startReloadTick == -1) {
                this.startReloadTick = player.f_19797_ + 5;
            }
            if (this.reloadTimer < 5) {
                ++this.reloadTimer;
            }
        } else {
            if (this.startReloadTick != -1) {
                this.startReloadTick = -1;
            }
            if (this.reloadTimer > 0) {
                --this.reloadTimer;
            }
        }
    }

    public int getStartReloadTick() {
        return this.startReloadTick;
    }

    public int getReloadTimer() {
        return this.reloadTimer;
    }

    public float getReloadProgress(float partialTicks) {
        return ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks) / 5.0f;
    }
}

