/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.IntArrayValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;

public interface FTBLibraryClientConfig {
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create("ftblibrary-client").comment("Client-specific configuration for FTB Library");
    public static final SNBTConfig TOOLTIPS = CONFIG.addGroup("tooltips");
    public static final BooleanValue ITEM_MODNAME = (BooleanValue)TOOLTIPS.addBoolean("item_modname", false).comment("Add the name of the mod that items belong to in the item selection GUI.\nNote that several common mods also do this (modnametooltip,WTHIT,EMI...) so this is false by default");
    public static final BooleanValue FLUID_MODNAME = (BooleanValue)TOOLTIPS.addBoolean("fluid_modname", true).comment("Add the name of the mod that fluids belong to in the fluid selection GUI.");
    public static final BooleanValue IMAGE_MODNAME = (BooleanValue)TOOLTIPS.addBoolean("image_modname", true).comment("Add the name of the mod that images belong to in the image selection GUI.");
    public static final SNBTConfig COLOR = CONFIG.addGroup("colorselector");
    public static final IntArrayValue RECENT = (IntArrayValue)COLOR.addIntArray("recents", new int[0]).comment("Colors recently selected in the color selector");

    public static void load() {
        ConfigUtil.loadDefaulted(CONFIG, ConfigUtil.LOCAL_DIR, "ftblibrary");
    }

    public static void save() {
        CONFIG.save(ConfigUtil.LOCAL_DIR.resolve("ftblibrary-client.snbt"));
    }

    public static ConfigGroup getConfigGroup() {
        ConfigGroup group = new ConfigGroup("ftblibrary.client_settings", accepted -> {
            if (accepted) {
                FTBLibraryClientConfig.save();
            }
        });
        CONFIG.createClientConfig(group);
        return group;
    }
}

