/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.big_cannon.AbstractBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonFuzePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public abstract class FuzedBigCannonProjectile
extends AbstractBigCannonProjectile {
    private ItemStack fuze = ItemStack.f_41583_;

    protected FuzedBigCannonProjectile(EntityType<? extends FuzedBigCannonProjectile> type, Level level) {
        super((EntityType<? extends AbstractBigCannonProjectile>)type, level);
    }

    public void setFuze(ItemStack stack) {
        this.fuze = stack == null || stack.m_41619_() ? ItemStack.f_41583_ : stack;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.canDetonate(fz -> fz.onProjectileTick(this.fuze, this))) {
            this.detonate((Position)this.m_20182_());
            this.removeNextTick = true;
        }
    }

    @Override
    protected boolean onClip(ProjectileContext ctx, Vec3 start, Vec3 end) {
        if (super.onClip(ctx, start, end)) {
            return true;
        }
        boolean baseFuze = this.getFuzeProperties().baseFuze();
        if (this.canDetonate(fz -> fz.onProjectileClip(this.fuze, this, start, end, ctx, baseFuze))) {
            this.detonate((Position)start);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onImpact(HitResult hitResult, AbstractCannonProjectile.ImpactResult impactResult, ProjectileContext projectileContext) {
        super.onImpact(hitResult, impactResult, projectileContext);
        boolean baseFuze = this.getFuzeProperties().baseFuze();
        if (this.canDetonate(fz -> fz.onProjectileImpact(this.fuze, this, hitResult, impactResult, baseFuze))) {
            this.detonate((Position)hitResult.m_82450_());
            return true;
        }
        return false;
    }

    @Nonnull
    protected abstract BigCannonFuzePropertiesComponent getFuzeProperties();

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Fuze", (Tag)this.fuze.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.fuze = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Fuze"));
    }

    protected final boolean canDetonate(Predicate<FuzeItem> cons) {
        FuzeItem fuzeItem;
        Item item;
        return !this.m_9236_().f_46443_ && this.m_9236_().m_46805_(this.m_20183_()) && !this.m_213877_() && (item = this.fuze.m_41720_()) instanceof FuzeItem && cons.test(fuzeItem = (FuzeItem)item);
    }

    @Deprecated
    protected void detonate() {
        this.detonate((Position)this.m_20182_());
    }

    protected abstract void detonate(Position var1);

    @Override
    public boolean canLingerInGround() {
        FuzeItem fuzeItem;
        Item item;
        return !this.m_9236_().f_46443_ && this.m_9236_().m_46805_(this.m_20183_()) && (item = this.fuze.m_41720_()) instanceof FuzeItem && (fuzeItem = (FuzeItem)item).canLingerInGround(this.fuze, this);
    }
}

