/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.special.monobogey;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MonoBogeyRenderer
extends BogeyRenderer {
    public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
        this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.MONOBOGEY_FRAME_UPRIGHT, CRBlockPartials.MONOBOGEY_FRAME_UPSIDE_DOWN});
        this.createModelInstance(materialManager, CRBlockPartials.MONOBOGEY_WHEEL, 4);
        this.createModelInstance(materialManager, (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.Z), 4);
    }

    public BogeySizes.BogeySize getSize() {
        return BogeySizes.SMALL;
    }

    public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
        boolean inInstancedContraption;
        boolean upsideDown = bogeyData.m_128471_("UpsideDown");
        boolean bl = inInstancedContraption = vb == null;
        if (!upsideDown) {
            this.renderUpright(wheelAngle, ms, light, vb, inInstancedContraption);
        } else {
            this.renderUpsideDown(wheelAngle, ms, light, vb, inContraption, inInstancedContraption);
        }
    }

    private void renderUpright(float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inInstancedContraption) {
        BogeyRenderer.BogeyModelData[] shafts = this.getTransform((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.Z), ms, inInstancedContraption, 4);
        for (boolean left : Iterate.trueAndFalse) {
            for (int front : Iterate.positiveAndNegative) {
                BogeyRenderer.BogeyModelData shaft = shafts[(left ? 1 : 0) + (front + 1)];
                ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)shaft.translate(left ? -1.3125 : 0.3125, 0.0, (double)(-0.5f + (float)(front * 8) / 16.0f)).centre()).rotateZ(left ? (double)wheelAngle : (double)(-wheelAngle))).unCentre()).render(ms, light, vb);
            }
        }
        this.getTransform(CRBlockPartials.MONOBOGEY_FRAME_UPRIGHT, ms, inInstancedContraption).render(ms, light, vb);
        BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.MONOBOGEY_WHEEL, ms, inInstancedContraption, 4);
        for (boolean left : Iterate.trueAndFalse) {
            for (int front : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[(left ? 1 : 0) + (front + 1)];
                ((BogeyRenderer.BogeyModelData)wheel.translate(left ? -0.8125 : 0.8125, 0.0, (double)((float)(front * 16) / 16.0f)).rotateY(left ? (double)wheelAngle : (double)(-wheelAngle))).translate(0.8125, 0.0, 1.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    private void renderUpsideDown(float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption, boolean inInstancedContraption) {
        boolean specialUpsideDown = !inContraption;
        BogeyRenderer.BogeyModelData[] shafts = this.getTransform((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.Z), ms, inInstancedContraption, 4);
        for (boolean left : Iterate.trueAndFalse) {
            for (int front : Iterate.positiveAndNegative) {
                BogeyRenderer.BogeyModelData shaft = shafts[(left ? 1 : 0) + (front + 1)];
                ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)shaft.translate(left ? -1.3125 : 0.3125, specialUpsideDown ? 2.0 : 0.0, (double)(-0.5f + (float)(front * 8) / 16.0f)).centre()).rotateZ(left ? (double)wheelAngle : (double)(-wheelAngle))).unCentre()).render(ms, light, vb);
            }
        }
        ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)this.getTransform(CRBlockPartials.MONOBOGEY_FRAME_UPSIDE_DOWN, ms, inInstancedContraption).rotateZ(specialUpsideDown ? 0.0 : 180.0)).translateY(specialUpsideDown ? 1.0 : -2.0)).render(ms, light, vb);
        BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.MONOBOGEY_WHEEL, ms, inInstancedContraption, 4);
        for (boolean left : Iterate.trueAndFalse) {
            for (int front : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[(left ? 1 : 0) + (front + 1)];
                ((BogeyRenderer.BogeyModelData)wheel.translate(left ? -0.8125 : 0.8125, specialUpsideDown ? 2.0 : 0.0, (double)((float)(front * 16) / 16.0f)).rotateY(left ? (double)wheelAngle : (double)(-wheelAngle))).translate(0.8125, 0.0, 1.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }
}

