/*
 * Decompiled with CFR 0.152.
 */
package net.felinamods.felsfirearmswwi.utils;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.felinamods.felsmgrwwii.network.FelsMgrwwiiModVariables;
import net.felinamods.felsmgrwwii.procedures.BulletEffectsProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class GunUtilsAdvanced {
    private static final Set<String> IGNORED_ENTITIES = Set.of("minecraft:armor_stand", "gray_fields:game_core", "gray_fields:point_a", "gray_fields:point_b", "gray_fields:flag", "gray_fields:flag_2", "gray_fields:explosion_entity_a", "gray_fields:explosion_entity_b");
    private static final Set<String> HARD_ENTITIES = Set.of("gray_fields:tsar_tank", "gray_fields:metal_barrier", "minecraft:iron_golem");

    public static void shootBullet(Level world, Entity shooter, double maxDistance, float baseDamage, boolean piercing, int pierceLimit, double falloffStart, double falloffEnd, float minMultiplier, double offsetForward, double offsetRight, double offsetUp) {
        if (shooter == null || world.f_46443_) {
            return;
        }
        Vec3 eyePos = new Vec3(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
        Vec3 lookVec = shooter.m_20154_();
        Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_();
        upVec = rightVec.m_82537_(lookVec).m_82541_();
        Vec3 offset = lookVec.m_82490_(offsetForward).m_82549_(rightVec.m_82490_(offsetRight)).m_82549_(upVec.m_82490_(offsetUp));
        Vec3 startPos = eyePos.m_82549_(offset);
        Vec3 endPos = startPos.m_82549_(lookVec.m_82490_(maxDistance));
        ClipContext context = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, shooter);
        BlockHitResult blockHit = world.m_45547_(context);
        Vec3 finalHitPos = blockHit.m_82450_();
        AABB hitbox = new AABB(startPos, finalHitPos).m_82400_(0.5);
        List entities = world.m_6249_(shooter, hitbox, e -> e != shooter && e.m_6084_());
        entities.sort(Comparator.comparingDouble(e -> e.m_20238_(startPos)));
        Scoreboard scoreboard = world.m_6188_();
        PlayerTeam shooterTeam = scoreboard.m_83500_(shooter.m_6302_());
        int pierceCount = 0;
        boolean bulletStopped = false;
        for (Entity entity : entities) {
            double headThreshold;
            AABB entityBox = entity.m_20191_().m_82400_(0.5);
            Optional intersection = entityBox.m_82371_(startPos, endPos);
            if (intersection.isEmpty()) continue;
            finalHitPos = (Vec3)intersection.get();
            String registryName = Optional.ofNullable(BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_())).map(ResourceLocation::toString).orElse("unknown");
            if (IGNORED_ENTITIES.contains(registryName)) continue;
            if (HARD_ENTITIES.contains(registryName)) {
                bulletStopped = true;
                break;
            }
            PlayerTeam targetTeam = scoreboard.m_83500_(entity.m_6302_());
            if (shooterTeam != null && shooterTeam == targetTeam) continue;
            double hitHeight = finalHitPos.f_82480_ - entity.m_20186_();
            boolean isHeadshot = hitHeight >= (headThreshold = (double)entity.m_20206_() * 0.85);
            float damage = baseDamage;
            double distance = startPos.m_82554_(finalHitPos);
            if (distance > falloffStart) {
                double t = Math.min((distance - falloffStart) / (falloffEnd - falloffStart), 1.0);
                float multiplier = (float)(1.0 - t * (1.0 - (double)minMultiplier));
                damage *= multiplier;
            }
            if (isHeadshot) {
                damage *= 2.0f;
            }
            entity.f_19802_ = 0;
            entity.m_6469_(world.m_269111_().m_269264_(), damage);
            boolean _setval = true;
            entity.getCapability(FelsMgrwwiiModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.hitmarker = _setval;
                capability.syncPlayerVariables(entity);
            });
            if (piercing && ++pierceCount < pierceLimit) continue;
            break;
        }
        if (bulletStopped || blockHit.m_6662_() == HitResult.Type.BLOCK || pierceCount == 0) {
            BulletEffectsProcedure.execute((LevelAccessor)world, finalHitPos.f_82479_, finalHitPos.f_82480_, finalHitPos.f_82481_);
        }
    }
}

