/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.registry.DoTBTags;

public class Utils {
    public static final int HIGHEST_Y = 255;
    public static final Component TOOLTIP_HOLD_SHIFT = Component.m_237115_((String)"tooltip.dawnoftimebuilder.hold_key").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"tooltip.dawnoftimebuilder.shift").m_130940_(ChatFormatting.AQUA));
    public static final String TOOLTIP_COLUMN = "column";
    public static final String TOOLTIP_BEAM = "beam";
    public static final String TOOLTIP_FIREPLACE = "fireplace";
    public static final String TOOLTIP_ADD_COLUMN = "add_column";

    public static boolean isShapeIncludedInShape(VoxelShape testedShape, VoxelShape faceShape, VoxelShape inShape) {
        VoxelShape shapeOnFace = Shapes.m_83113_((VoxelShape)testedShape, (VoxelShape)faceShape, (BooleanOp)BooleanOp.f_82689_);
        return !Shapes.m_83157_((VoxelShape)shapeOnFace, (VoxelShape)inShape, (BooleanOp)BooleanOp.f_82685_);
    }

    public static boolean clickedOnLeftHalf(BlockPos clickedPos, Direction dir, Vec3 clickLocation) {
        int dirStepX = dir.m_122429_();
        int dirStepZ = dir.m_122431_();
        double diffX = clickLocation.f_82479_ - (double)clickedPos.m_123341_();
        double diffZ = clickLocation.f_82481_ - (double)clickedPos.m_123343_();
        return !(dirStepX < 0 && diffZ < 0.5 || dirStepX > 0 && diffZ > 0.5 || dirStepZ < 0 && diffX > 0.5 || dirStepZ > 0 && diffX < 0.5);
    }

    public static boolean useLighter(Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        ItemStack itemInHand = player.m_21120_(handIn);
        if (!itemInHand.m_41619_() && itemInHand.m_204117_(DoTBTags.INSTANCE.LIGHTERS)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(handIn));
            return true;
        }
        return false;
    }

    public static boolean useFireActivatorOnBlockIfPossible(BlockState blockstateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        if (((Boolean)blockstateIn.m_61143_((Property)WaterloggedBlock.WATERLOGGED)).booleanValue()) {
            return false;
        }
        ItemStack itemStackInHand = player.m_21120_(handIn);
        if (!itemStackInHand.m_41619_()) {
            Item itemInHand = itemStackInHand.m_41720_();
            if (itemInHand instanceof FireChargeItem) {
                if (!player.m_7500_()) {
                    player.m_21205_().m_41774_(1);
                }
                return true;
            }
            if (itemStackInHand.m_204117_(DoTBTags.INSTANCE.LIGHTERS)) {
                worldIn.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    itemStackInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(handIn));
                }
                return true;
            }
        }
        return false;
    }

    public static boolean useFireStopperIfPossible(BlockState blockstateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        ItemStack mainItemStack = player.m_21205_();
        if (player.m_7500_()) {
            return true;
        }
        if (mainItemStack.m_41619_()) {
            return false;
        }
        if (mainItemStack.m_204117_(DoTBTags.INSTANCE.LIGHTERS)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                mainItemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(handIn));
            }
            return true;
        }
        if (mainItemStack.m_41720_() instanceof PotionItem && !(mainItemStack.m_41720_() instanceof SplashPotionItem)) {
            Potion potion = PotionUtils.m_43579_((ItemStack)mainItemStack);
            if (potion != null && potion.m_43488_().size() <= 0) {
                player.m_21205_().m_41774_(1);
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                return true;
            }
        } else if (mainItemStack.m_41720_() instanceof SnowballItem) {
            player.m_21205_().m_41774_(1);
            return true;
        }
        return false;
    }

    public static int changeBlockLitStateWithItemOrCreativePlayer(BlockState stateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        int activation;
        block8: {
            activation = -1;
            if (((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() && Utils.useFireStopperIfPossible(stateIn, worldIn, pos, player, handIn)) {
                activation = 0;
            } else if (!((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() && Utils.useFireActivatorOnBlockIfPossible(stateIn, worldIn, pos, player, handIn)) {
                activation = 1;
            }
            if (activation < 0) break block8;
            boolean isActivated = activation == 1;
            worldIn.m_7731_(pos, (BlockState)stateIn.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(isActivated)), 10);
            worldIn.m_5594_(null, pos, isActivated ? SoundEvents.f_11936_ : SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (worldIn.f_46443_) {
                if (!isActivated) {
                    for (int i = 0; i < worldIn.f_46441_.m_188503_(4) + 2; ++i) {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (double)(worldIn.f_46441_.m_188501_() / 4.0f), 2.5E-5, (double)(worldIn.f_46441_.m_188501_() / 4.0f));
                    }
                } else {
                    for (int i = 0; i < worldIn.f_46441_.m_188503_(4) + 2; ++i) {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (double)(worldIn.f_46441_.m_188501_() / 4.0f), 2.5E-5, (double)(worldIn.f_46441_.m_188501_() / 4.0f));
                    }
                }
            }
        }
        return activation;
    }

    public static void addTooltip(List<Component> tooltip, @Nonnull Item item, String ... tooltipNames) {
        ResourceLocation itemName = item.m_204114_().m_205785_().m_135782_();
        if (itemName != null) {
            String[] tts = new String[tooltipNames.length + 1];
            System.arraycopy(tooltipNames, 0, tts, 0, tooltipNames.length);
            tts[tooltipNames.length] = itemName.m_135815_();
            Utils.addTooltip(tooltip, tts);
        }
    }

    public static void addTooltip(List<Component> tooltip, @Nonnull Block block, String ... tooltipNames) {
        ResourceLocation itemName = block.m_204297_().m_205785_().m_135782_();
        if (itemName != null) {
            String[] tts = new String[tooltipNames.length + 1];
            System.arraycopy(tooltipNames, 0, tts, 0, tooltipNames.length);
            tts[tooltipNames.length] = itemName.m_135815_();
            Utils.addTooltip(tooltip, tts);
        }
    }

    public static void addTooltip(List<Component> tooltip, String ... tooltipNames) {
        if (Screen.m_96638_()) {
            for (String tooltipName : tooltipNames) {
                tooltip.add((Component)Component.m_237115_((String)("tooltip.dawnoftimebuilder." + tooltipName)).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add(TOOLTIP_HOLD_SHIFT);
        }
    }
}

