/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.IBlockPillar;
import org.dawnoftime.dawnoftime.block.templates.BeamBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class SupportBeamBlock
extends WaterloggedBlock {
    private static final EnumProperty<BlockStatePropertiesAA.PillarConnection> PILLAR_CONNECTION = BlockStatePropertiesAA.PILLAR_CONNECTION;
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    private static final BooleanProperty SUBAXIS = BlockStatePropertiesAA.SUBAXIS;

    public SupportBeamBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SUPPORT_BEAM_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)SUBAXIS, (Comparable)Boolean.valueOf(false))).m_61124_(PILLAR_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.PillarConnection.NOTHING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PILLAR_CONNECTION, HORIZONTAL_AXIS, SUBAXIS});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index;
        switch ((BlockStatePropertiesAA.PillarConnection)((Object)state.m_61143_(PILLAR_CONNECTION))) {
            case FOUR_PX: {
                int n = 3;
                break;
            }
            case EIGHT_PX: {
                int n = 6;
                break;
            }
            case TEN_PX: {
                int n = 9;
                break;
            }
            default: {
                int n = index = 0;
            }
        }
        if (((Boolean)state.m_61143_((Property)SUBAXIS)).booleanValue()) {
            return index + 2;
        }
        return state.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.Z ? index + 1 : index;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)super.m_5573_(context).m_61124_(HORIZONTAL_AXIS, (Comparable)context.m_8125_().m_122434_());
        return this.getCurrentState(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return this.getCurrentState(stateIn, worldIn, currentPos);
    }

    private BlockState getCurrentState(BlockState stateIn, LevelAccessor worldIn, BlockPos currentPos) {
        if (stateIn.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.X) {
            if (this.canConnect(worldIn, currentPos, Direction.NORTH) || this.canConnect(worldIn, currentPos, Direction.SOUTH)) {
                stateIn = (BlockState)stateIn.m_61124_((Property)SUBAXIS, (Comparable)Boolean.valueOf(true));
            }
        } else if (this.canConnect(worldIn, currentPos, Direction.EAST) || this.canConnect(worldIn, currentPos, Direction.WEST)) {
            stateIn = (BlockState)stateIn.m_61124_((Property)SUBAXIS, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)stateIn.m_61124_(PILLAR_CONNECTION, (Comparable)((Object)IBlockPillar.getPillarConnectionAbove(worldIn, currentPos.m_7495_())));
    }

    private boolean canConnect(LevelAccessor world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos.m_121945_(direction));
        return this.isConnectibleBeam(state, direction) || this.isConnectibleSupportBeam(state, direction) || this.isConnectibleBeam(state, direction) || this.isConnectibleSupportBeam(state, direction);
    }

    private boolean isConnectibleBeam(BlockState state, Direction direction) {
        if (state.m_60734_() instanceof BeamBlock) {
            return direction.m_122434_() == Direction.Axis.X ? ((Boolean)state.m_61143_((Property)BeamBlock.AXIS_X)).booleanValue() : ((Boolean)state.m_61143_((Property)BeamBlock.AXIS_Z)).booleanValue();
        }
        return false;
    }

    private boolean isConnectibleSupportBeam(BlockState state, Direction direction) {
        if (state.m_60734_() instanceof SupportBeamBlock) {
            return state.m_61143_(HORIZONTAL_AXIS) == direction.m_122434_();
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            return (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)(state.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return super.m_6843_(state, rot);
    }
}

