/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.dawnoftime.block.templates.SlabBlockDoT;

public class MixedRoofSupportBlock
extends SlabBlockDoT {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    private final Supplier<Block> roofSlabBlockSupplier;

    public MixedRoofSupportBlock(Supplier<Block> roofSlabBlockSupplier, BlockBehaviour.Properties properties) {
        super(properties);
        this.roofSlabBlockSupplier = roofSlabBlockSupplier;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)SlabBlock.f_56354_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, SHAPE});
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockpos);
        Direction direction = context.m_43719_();
        newState = (BlockState)newState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)(direction != Direction.DOWN && (direction == Direction.UP || context.m_43720_().f_82480_ - (double)blockpos.m_123342_() <= 0.5) ? SlabType.BOTTOM : SlabType.TOP));
        return (BlockState)((BlockState)newState.m_61124_((Property)SlabBlock.f_56354_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_(SHAPE, (Comparable)this.getShapeProperty(newState, (LevelReader)context.m_43725_(), pos));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Direction facing = hit.m_82434_();
        ItemStack itemStack = player.m_21120_(handIn);
        if (!player.m_6047_() && player.m_36204_(pos, facing, itemStack) && facing.m_122434_().m_122478_() && !itemStack.m_41619_() && facing == Direction.UP && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM && itemStack.m_41720_() == this.roofSlabBlockSupplier.get().m_5456_() && worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE), 11)) {
            this.m_6402_(worldIn, pos, state, (LivingEntity)player, itemStack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, pos, itemStack);
            }
            SoundType soundtype = this.m_49962_(state);
            worldIn.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public static Item getBlockItem(MixedRoofSupportBlock block) {
        return new BlockItem((Block)block, new Item.Properties()){

            public InteractionResult m_40576_(BlockPlaceContext context) {
                Direction facing = context.m_43719_();
                if (context.m_43723_() != null && context.m_43723_().m_6047_() || !facing.m_122434_().m_122478_()) {
                    return super.m_40576_(context);
                }
                Player player = context.m_43723_();
                ItemStack itemStack = context.m_43722_();
                Level worldIn = context.m_43725_();
                BlockPos pos = context.m_8083_();
                if (!context.m_7058_()) {
                    pos = pos.m_121945_(facing.m_122424_());
                }
                if (player != null && !player.m_36204_(pos, facing, itemStack)) {
                    return super.m_40576_(context);
                }
                if (!itemStack.m_41619_()) {
                    BlockState state = worldIn.m_8055_(pos);
                    MixedRoofSupportBlock block = (MixedRoofSupportBlock)this.m_40614_();
                    if (state.m_60734_() == block.roofSlabBlockSupplier.get() && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP) {
                        BlockState madeState = block.m_5573_(context);
                        if (madeState == null) {
                            return super.m_40576_(context);
                        }
                        if (worldIn.m_7731_(pos, (BlockState)(madeState = (BlockState)madeState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)).m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE), 11)) {
                            this.m_40614_().m_6402_(worldIn, pos, state, (LivingEntity)player, itemStack);
                            if (player instanceof ServerPlayer) {
                                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, pos, itemStack);
                            }
                            SoundType soundtype = block.m_49962_(state);
                            worldIn.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                            itemStack.m_41774_(1);
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
                return super.m_40576_(context);
            }
        };
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing.m_122434_().m_122479_() ? (BlockState)stateIn.m_61124_(SHAPE, (Comparable)this.getShapeProperty(stateIn, (LevelReader)worldIn, currentPos)) : stateIn;
    }

    private StairsShape getShapeProperty(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction adjacentDirection;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState adjacentState = worldIn.m_8055_(pos.m_121945_(direction));
        if (this.isSameBlock(adjacentState) && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP == (adjacentState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP) && (adjacentDirection = (Direction)adjacentState.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && this.isConnectableRoofSupport(state, worldIn, pos, adjacentDirection.m_122424_())) {
            return adjacentDirection == direction.m_122428_() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        adjacentState = worldIn.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (this.isSameBlock(adjacentState) && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP == (adjacentState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP) && (adjacentDirection = (Direction)adjacentState.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && this.isConnectableRoofSupport(state, worldIn, pos, adjacentDirection)) {
            return adjacentDirection == direction.m_122428_() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private boolean isConnectableRoofSupport(BlockState state, LevelReader worldIn, BlockPos pos, Direction face) {
        BlockState adjacentState = worldIn.m_8055_(pos.m_121945_(face));
        return !this.isSameBlock(adjacentState) || adjacentState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || adjacentState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP != (state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP);
    }

    public boolean isSameBlock(BlockState state) {
        return state.m_60734_() == this;
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || fluid.m_76152_() != Fluids.f_76193_) {
            return false;
        }
        if (!world.m_5776_()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 3);
            world.m_186469_(pos, fluid.m_76152_(), fluid.m_76152_().m_6718_((LevelReader)world));
        }
        return true;
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(state, mirrorIn);
    }
}

