/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class EdgeBlock
extends WaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;

    public EdgeBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public EdgeBlock(BlockBehaviour.Properties properties) {
        this(properties, VoxelShapes.EDGE_SHAPES);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, HALF, SHAPE});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = (((Direction)state.m_61143_((Property)FACING)).m_122416_() + 2) % 4;
        index *= 3;
        switch ((StairsShape)state.m_61143_(SHAPE)) {
            default: {
                break;
            }
            case OUTER_RIGHT: {
                index += 3;
                break;
            }
            case STRAIGHT: {
                ++index;
                break;
            }
            case INNER_LEFT: {
                index += 2;
                break;
            }
            case INNER_RIGHT: {
                index += 5;
            }
        }
        return state.m_61143_(HALF) == Half.BOTTOM ? index : (index %= 12) + 12;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        Direction direction = context.m_43719_();
        BlockPos pos = context.m_8083_();
        state = (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)(direction != Direction.DOWN && (direction == Direction.UP || context.m_43720_().f_82480_ - (double)pos.m_123342_() <= 0.5) ? Half.BOTTOM : Half.TOP));
        return (BlockState)state.m_61124_(SHAPE, (Comparable)EdgeBlock.getShapeProperty(state, (LevelReader)context.m_43725_(), pos));
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing.m_122434_().m_122479_() ? (BlockState)stateIn.m_61124_(SHAPE, (Comparable)EdgeBlock.getShapeProperty(stateIn, (LevelReader)worldIn, currentPos)) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static StairsShape getShapeProperty(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction adjacentDirection;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState adjacentState = worldIn.m_8055_(pos.m_121945_(direction));
        if (EdgeBlock.isBlockEdge(adjacentState) && state.m_61143_(HALF) == adjacentState.m_61143_(HALF) && (adjacentDirection = (Direction)adjacentState.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && EdgeBlock.isDifferentEdge(state, worldIn, pos, adjacentDirection.m_122424_())) {
            return adjacentDirection == direction.m_122428_() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        adjacentState = worldIn.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (EdgeBlock.isBlockEdge(adjacentState) && state.m_61143_(HALF) == adjacentState.m_61143_(HALF) && (adjacentDirection = (Direction)adjacentState.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && EdgeBlock.isDifferentEdge(state, worldIn, pos, adjacentDirection)) {
            return adjacentDirection == direction.m_122428_() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentEdge(BlockState state, LevelReader worldIn, BlockPos pos, Direction face) {
        BlockState adjacentState = worldIn.m_8055_(pos.m_121945_(face));
        return !EdgeBlock.isBlockEdge(adjacentState) || adjacentState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || adjacentState.m_61143_(HALF) != state.m_61143_(HALF);
    }

    public static boolean isBlockEdge(BlockState state) {
        return state.m_60734_() instanceof EdgeBlock;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                return switch (stairsshape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return switch (stairsshape) {
                    default -> throw new IncompatibleClassChangeError();
                    case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.m_6943_(state, mirrorIn);
    }
}

