/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.IBlockSpecialDisplay;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.Utils;

public abstract class CandleLampBlock
extends WaterloggedBlock
implements IBlockSpecialDisplay {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public CandleLampBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }

    public void animateLitCandle(BlockState stateIn, Level worldIn, BlockPos pos, double x, double y, double z) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + x;
            double d1 = (double)pos.m_123342_() + y;
            double d2 = (double)pos.m_123343_() + z;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.01, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return Utils.changeBlockLitStateWithItemOrCreativePlayer(state, worldIn, pos, player, handIn) >= 0 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        int activation = -1;
        if (!((Boolean)state.m_61143_((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && (projectile instanceof AbstractArrow && ((AbstractArrow)projectile).m_6060_() || projectile instanceof Fireball)) {
            activation = 1;
        } else if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && (projectile instanceof Snowball || projectile instanceof ThrowableProjectile && PotionUtils.m_43579_((ItemStack)((ThrowableItemProjectile)projectile).m_7846_()).m_43488_().size() <= 0)) {
            activation = 0;
        }
        if (activation >= 0) {
            boolean isActivated;
            BlockPos pos = hit.m_82425_();
            boolean bl = isActivated = activation == 1;
            if (!worldIn.m_5776_()) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(isActivated)), 10);
                worldIn.m_5594_(null, pos, isActivated ? SoundEvents.f_11936_ : SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!isActivated && worldIn.m_5776_()) {
                for (int i = 0; i < worldIn.f_46441_.m_188503_(1) + 1; ++i) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (double)(worldIn.f_46441_.m_188501_() / 4.0f), 2.5E-5, (double)(worldIn.f_46441_.m_188501_() / 4.0f));
                }
            }
        }
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (((Boolean)state.m_61143_((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() || fluid.m_76152_() != Fluids.f_76193_) {
            return false;
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 10);
        world.m_186469_(pos, fluid.m_76152_(), fluid.m_76152_().m_6718_((LevelReader)world));
        return true;
    }

    @Override
    public boolean emitsLight() {
        return true;
    }
}

