/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.roman;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class MarbleStatueBlock
extends WaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty MULTIBLOCK = BlockStatePropertiesAA.MULTIBLOCK_0_2;

    public MarbleStatueBlock(BlockBehaviour.Properties properties) {
        super(properties.m_278166_(PushReaction.DESTROY), VoxelShapes.MARBLE_STATUE_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)MULTIBLOCK, (Comparable)Integer.valueOf(0))).m_61124_((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, MULTIBLOCK});
    }

    public void m_5707_(Level worldIn, BlockPos blockPosIn, BlockState blockStateIn, Player playerEntityIn) {
        int multiblockValue;
        if (!worldIn.m_5776_() && playerEntityIn.m_7500_() && (multiblockValue = ((Integer)blockStateIn.m_61143_((Property)MULTIBLOCK)).intValue()) > 0) {
            BlockPos blockPos = blockPosIn.m_6625_(multiblockValue);
            BlockState blockState = worldIn.m_8055_(blockPos);
            worldIn.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(playerEntityIn, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        super.m_5707_(worldIn, blockPosIn, blockStateIn, playerEntityIn);
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.m_61143_((Property)MULTIBLOCK) == 2 ? 1 : 0;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (!level.m_8055_(pos.m_7494_()).m_60629_(context) || !level.m_8055_(pos.m_6630_(2)).m_60629_(context)) {
            return null;
        }
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos abovePos = pos.m_7494_();
        worldIn.m_7731_(abovePos, (BlockState)((BlockState)state.m_61124_((Property)MULTIBLOCK, (Comparable)Integer.valueOf(1))).m_61124_((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_6425_(abovePos).m_76152_() == Fluids.f_76193_)), 10);
        abovePos = abovePos.m_7494_();
        worldIn.m_7731_(abovePos, (BlockState)((BlockState)state.m_61124_((Property)MULTIBLOCK, (Comparable)Integer.valueOf(2))).m_61124_((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_6425_(abovePos).m_76152_() == Fluids.f_76193_)), 10);
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing.m_122434_().m_122479_()) {
            return stateIn;
        }
        int multipart = (Integer)stateIn.m_61143_((Property)MULTIBLOCK);
        if (facing == Direction.UP && multipart < 2 && facingState.m_60734_() == this && facingState.m_61143_((Property)FACING) == stateIn.m_61143_((Property)FACING) && (Integer)facingState.m_61143_((Property)MULTIBLOCK) == multipart + 1) {
            return stateIn;
        }
        if (facing == Direction.DOWN && multipart > 0 && facingState.m_60734_() == this && facingState.m_61143_((Property)FACING) == stateIn.m_61143_((Property)FACING) && (Integer)facingState.m_61143_((Property)MULTIBLOCK) == multipart - 1) {
            return stateIn;
        }
        return Blocks.f_50016_.m_49966_();
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, @NotNull Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirror) {
        return this.m_6843_(state, mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

