/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.general;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.BlockDoT;
import org.dawnoftime.dawnoftime.block.templates.PoolBlock;
import org.dawnoftime.dawnoftime.registry.DoTBBlocksRegistry;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.jetbrains.annotations.Nullable;

public abstract class WaterTrickleBlock
extends BlockDoT {
    public WaterTrickleBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn.m_278166_(PushReaction.DESTROY).m_60953_(state -> 1));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStatePropertiesAA.NORTH_TRICKLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStatePropertiesAA.EAST_TRICKLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStatePropertiesAA.SOUTH_TRICKLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStatePropertiesAA.WEST_TRICKLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStatePropertiesAA.CENTER_TRICKLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61361_, (Comparable)Boolean.valueOf(true))).m_61124_(BlockStatePropertiesAA.WATER_TRICKLE_END, (Comparable)((Object)BlockStatePropertiesAA.WaterTrickleEnd.FADE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStatePropertiesAA.NORTH_TRICKLE, BlockStatePropertiesAA.EAST_TRICKLE, BlockStatePropertiesAA.SOUTH_TRICKLE, BlockStatePropertiesAA.WEST_TRICKLE, BlockStatePropertiesAA.CENTER_TRICKLE, BlockStateProperties.f_61361_, BlockStatePropertiesAA.WATER_TRICKLE_END});
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.m_5776_() && ((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61361_)).booleanValue()) {
            pLevel.m_186460_(pPos, (Block)this, 5);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction directionIn, BlockState facingStateIn, LevelAccessor worldIn, BlockPos currentPosIn, BlockPos facingPosIn) {
        if (directionIn == Direction.UP && facingStateIn.m_60734_() instanceof WaterTrickleBlock) {
            if (!worldIn.m_5776_()) {
                worldIn.m_186460_(currentPosIn, (Block)this, 5);
            }
            return (BlockState)stateIn.m_61124_((Property)BlockStateProperties.f_61361_, (Comparable)Boolean.valueOf(true));
        }
        if (directionIn == Direction.DOWN && worldIn instanceof Level) {
            if (!worldIn.m_5776_()) {
                worldIn.m_186460_(currentPosIn, (Block)this, 5);
            }
            return (BlockState)((BlockState)stateIn.m_61124_(BlockStatePropertiesAA.WATER_TRICKLE_END, (Comparable)((Object)this.getWaterTrickleEnd((Level)worldIn, facingPosIn, facingStateIn)))).m_61124_((Property)BlockStateProperties.f_61361_, (Comparable)Boolean.valueOf(true));
        }
        return stateIn;
    }

    public boolean[] getWaterTrickleOutPut(BlockState currentState) {
        return new boolean[]{(Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.NORTH_TRICKLE), (Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.EAST_TRICKLE), (Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.SOUTH_TRICKLE), (Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.WEST_TRICKLE), (Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.CENTER_TRICKLE)};
    }

    public BlockState inheritWaterTrickles(BlockState currentState, BlockState aboveState) {
        boolean[] trickles = ((WaterTrickleBlock)aboveState.m_60734_()).getWaterTrickleOutPut(aboveState);
        BooleanProperty[] properties = new BooleanProperty[]{BlockStatePropertiesAA.NORTH_TRICKLE, BlockStatePropertiesAA.EAST_TRICKLE, BlockStatePropertiesAA.SOUTH_TRICKLE, BlockStatePropertiesAA.WEST_TRICKLE, BlockStatePropertiesAA.CENTER_TRICKLE};
        int i = 0;
        BlockState updatedState = currentState;
        for (BooleanProperty property : properties) {
            if ((Boolean)currentState.m_61143_((Property)property) != trickles[i]) {
                updatedState = (BlockState)((BlockState)updatedState.m_61124_((Property)property, (Comparable)Boolean.valueOf(trickles[i]))).m_61124_((Property)BlockStateProperties.f_61361_, (Comparable)Boolean.valueOf(true));
            }
            ++i;
        }
        return updatedState;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockState updatedState;
        super.m_213897_(state, world, pos, rand);
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61361_, (Comparable)Boolean.valueOf(false));
        BlockPos bottomPos = pos.m_7495_();
        BlockState bottomState = world.m_8055_(bottomPos);
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = world.m_8055_(abovePos);
        if (bottomState.m_60734_() instanceof WaterTrickleBlock) {
            updatedState = this.inheritWaterTrickles(bottomState, state);
            if (((Boolean)updatedState.m_61143_((Property)BlockStateProperties.f_61361_)).booleanValue()) {
                world.m_7731_(bottomPos, (BlockState)bottomState.m_61124_((Property)BlockStateProperties.f_61361_, (Comparable)Boolean.valueOf(true)), 10);
            }
        } else if (bottomState.m_60629_(this.generateContext((Level)world, bottomPos)) && world.m_6425_(bottomPos).m_76152_().equals(Fluids.f_76191_)) {
            bottomState = this.createFlowingTrickle(bottomState, this.getWaterTrickleOutPut(state), (Level)world, bottomPos);
        } else if (bottomState.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)bottomState.m_60734_()).m_6044_((BlockGetter)world, bottomPos, bottomState, (Fluid)Fluids.f_76193_)) {
            ((LiquidBlockContainer)bottomState.m_60734_()).m_7361_((LevelAccessor)world, bottomPos, bottomState, Fluids.f_76193_.m_76068_(false));
        }
        updatedState = this.updateWaterTrickle((Level)world, state, bottomPos, bottomState, aboveState);
        world.m_7731_(pos, updatedState, 10);
    }

    public BlockState updateWaterTrickle(Level world, BlockState currentState, BlockPos bottomPos, BlockState bottomState, BlockState aboveState) {
        BlockStatePropertiesAA.WaterTrickleEnd lowerEnd = this.getWaterTrickleEnd(world, bottomPos, bottomState);
        currentState = (BlockState)currentState.m_61124_(BlockStatePropertiesAA.WATER_TRICKLE_END, (Comparable)((Object)lowerEnd));
        currentState = aboveState.m_60734_() instanceof WaterTrickleBlock ? this.inheritWaterTrickles(currentState, aboveState) : this.inheritWaterTrickles(currentState, this.m_49966_());
        return currentState;
    }

    public BlockState createFlowingTrickle(BlockState currentState, boolean[] trickles, Level world, BlockPos waterTricklePos) {
        BooleanProperty[] properties = new BooleanProperty[]{BlockStatePropertiesAA.NORTH_TRICKLE, BlockStatePropertiesAA.EAST_TRICKLE, BlockStatePropertiesAA.SOUTH_TRICKLE, BlockStatePropertiesAA.WEST_TRICKLE, BlockStatePropertiesAA.CENTER_TRICKLE};
        int i = 0;
        int numberOfTrickle = 0;
        BlockState waterTrickleState = DoTBBlocksRegistry.INSTANCE.WATER_FLOWING_TRICKLE.get().m_49966_();
        for (BooleanProperty property : properties) {
            waterTrickleState = (BlockState)waterTrickleState.m_61124_((Property)property, (Comparable)Boolean.valueOf(trickles[i]));
            if (trickles[i]) {
                ++numberOfTrickle;
            }
            ++i;
        }
        if (numberOfTrickle > 0) {
            world.m_7731_(waterTricklePos, waterTrickleState, 10);
            return waterTrickleState;
        }
        return currentState;
    }

    public void m_214162_(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        super.m_214162_(state, worldIn, pos, rand);
        boolean[] trickles = this.getWaterTrickleOutPut(state);
        if (state.m_61143_(BlockStatePropertiesAA.WATER_TRICKLE_END) == BlockStatePropertiesAA.WaterTrickleEnd.SPLASH) {
            this.spawnFullParticles(worldIn, pos, trickles[0], rand, 0.5, 0.4);
            this.spawnFullParticles(worldIn, pos, trickles[1], rand, 0.6, 0.5);
            this.spawnFullParticles(worldIn, pos, trickles[2], rand, 0.5, 0.6);
            this.spawnFullParticles(worldIn, pos, trickles[3], rand, 0.5, 0.6);
            this.spawnFullParticles(worldIn, pos, trickles[4], rand, 0.5, 0.5);
            return;
        }
        BlockState belowState = worldIn.m_8055_(pos.m_7495_());
        if (belowState.m_60734_() instanceof PoolBlock && (Integer)belowState.m_61143_((Property)BlockStatePropertiesAA.LEVEL) > ((PoolBlock)belowState.m_60734_()).faucetLevel) {
            this.spawnLimitedParticles(worldIn, pos, trickles[0], rand, 0.5, 0.4);
            this.spawnLimitedParticles(worldIn, pos, trickles[1], rand, 0.6, 0.5);
            this.spawnLimitedParticles(worldIn, pos, trickles[2], rand, 0.5, 0.6);
            this.spawnLimitedParticles(worldIn, pos, trickles[3], rand, 0.5, 0.6);
            this.spawnLimitedParticles(worldIn, pos, trickles[4], rand, 0.5, 0.5);
        }
    }

    private void spawnLimitedParticles(Level worldIn, BlockPos pos, boolean isOn, RandomSource rand, double xOffset, double zOffset) {
        if (isOn) {
            double offset = 0.75;
            worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123772_, true, (double)pos.m_123341_() + xOffset + (rand.m_188500_() * offset - offset / 2.0), (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + zOffset + (rand.m_188500_() * offset - offset / 2.0), 0.0125, 0.075, 0.0125);
            offset = 0.6;
            worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)pos.m_123341_() + xOffset + (rand.m_188500_() * offset - offset / 2.0), (double)pos.m_123342_() + 0.0, (double)pos.m_123343_() + zOffset + (rand.m_188500_() * offset - offset / 2.0), 5.0E-4, 0.01, 5.0E-4);
        }
    }

    private void spawnFullParticles(Level worldIn, BlockPos pos, boolean isOn, RandomSource rand, double xOffset, double zOffset) {
        if (isOn) {
            for (int i = 0; i < 4; ++i) {
                double offset = 0.75;
                worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123772_, true, (double)pos.m_123341_() + xOffset + (rand.m_188500_() * offset - offset / 2.0), (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + zOffset + (rand.m_188500_() * offset - offset / 2.0), 0.0125, 0.075, 0.0125);
                offset = 0.6;
                worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)pos.m_123341_() + xOffset + (rand.m_188500_() * offset - offset / 2.0), (double)pos.m_123342_() + 0.0, (double)pos.m_123343_() + zOffset + (rand.m_188500_() * offset - offset / 2.0), 5.0E-4, 0.01, 5.0E-4);
            }
        }
    }

    protected BlockStatePropertiesAA.WaterTrickleEnd getWaterTrickleEnd(Level level, BlockPos bottomPos, BlockState bottomState) {
        if (bottomState.m_60734_() instanceof WaterTrickleBlock) {
            return BlockStatePropertiesAA.WaterTrickleEnd.STRAIGHT;
        }
        if (!level.m_6425_(bottomPos).m_76152_().equals(Fluids.f_76191_)) {
            return BlockStatePropertiesAA.WaterTrickleEnd.SPLASH;
        }
        return BlockStatePropertiesAA.WaterTrickleEnd.FADE;
    }

    private BlockPlaceContext generateContext(Level level, BlockPos fromPos) {
        Vec3 vec = new Vec3((double)fromPos.m_123341_() + 0.5, (double)fromPos.m_123342_(), (double)fromPos.m_123343_() + 0.5);
        return new CustomBlockPlaceContext(level, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, new BlockHitResult(vec, Direction.DOWN, fromPos, false));
    }

    protected static BooleanProperty getPropertyFromDirection(Direction facing) {
        return switch (facing) {
            default -> BlockStatePropertiesAA.CENTER;
            case Direction.NORTH -> BlockStateProperties.f_61368_;
            case Direction.SOUTH -> BlockStateProperties.f_61370_;
            case Direction.WEST -> BlockStateProperties.f_61371_;
            case Direction.EAST -> BlockStateProperties.f_61369_;
        };
    }

    public int m_7753_(BlockState p_200011_1_In, BlockGetter p_200011_2_In, BlockPos p_200011_3_In) {
        return 1;
    }

    public boolean m_7923_(BlockState p_220074_1_In) {
        return false;
    }

    public VoxelShape m_7952_(BlockState p_196247_1_In, BlockGetter p_196247_2_In, BlockPos p_196247_3_In) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState p_200123_1_In, BlockGetter p_200123_2_In, BlockPos p_200123_3_In) {
        return true;
    }

    private static class CustomBlockPlaceContext
    extends BlockPlaceContext {
        public CustomBlockPlaceContext(Level level, @Nullable Player player, InteractionHand hand, ItemStack itemStack, BlockHitResult hitResult) {
            super(level, player, hand, itemStack, hitResult);
        }
    }
}

