/*
 * Decompiled with CFR 0.152.
 */
package net.felinamods.felsmgrwwii.utils;

import java.util.List;
import java.util.Optional;
import net.felinamods.felsmgrwwii.entity.TracerEffect2Entity;
import net.felinamods.felsmgrwwii.entity.TracerEffectEntity;
import net.felinamods.felsmgrwwii.init.FelsMgrwwiiModEntities;
import net.felinamods.felsmgrwwii.procedures.BulletEffectsProcedure;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GunUtils {
    public static void shootBullet(Level world, Entity shooter, double maxDistance, float damage, boolean piercing, int pierceLimit, int tracerCount) {
        if (shooter == null || world.f_46443_) {
            return;
        }
        Vec3 startPos = shooter.m_146892_();
        Vec3 lookVector = shooter.m_20154_();
        Vec3 endPos = startPos.m_82549_(lookVector.m_82490_(maxDistance));
        ClipContext context = new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, shooter);
        BlockHitResult blockHit = world.m_45547_(context);
        Vec3 finalHitPos = blockHit.m_82450_();
        AABB hitbox = new AABB(startPos, finalHitPos).m_82400_(0.5);
        List entities = world.m_6249_(shooter, hitbox, entity -> entity != shooter && entity.m_6084_());
        entities.sort((e1, e2) -> Double.compare(e1.m_20238_(startPos), e2.m_20238_(startPos)));
        int pierceCount = 0;
        TagKey hardEntitiesTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("fels_mgrwwii", "hard_entities"));
        TagKey tracerEntitiesTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("fels_mgrwwii", "tracers"));
        for (Entity entity2 : entities) {
            AABB entityBox;
            Optional intersection;
            if (entity2.m_6095_().m_204039_(tracerEntitiesTag) || !(intersection = (entityBox = entity2.m_20191_().m_82400_(0.5)).m_82371_(startPos, endPos)).isPresent()) continue;
            if (!entity2.m_6095_().m_204039_(hardEntitiesTag)) {
                entity2.f_19802_ = 0;
                entity2.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_)), damage);
                ++pierceCount;
            }
            if (piercing && pierceCount < pierceLimit) continue;
            break;
        }
        if (blockHit.m_6662_() == HitResult.Type.BLOCK || pierceCount == 0) {
            BulletEffectsProcedure.execute((LevelAccessor)world, finalHitPos.f_82479_, finalHitPos.f_82480_, finalHitPos.f_82481_);
        }
        if (tracerCount == 1) {
            GunUtils.spawnTracerEntity(world, shooter, startPos, lookVector);
        } else if (tracerCount == 2) {
            GunUtils.spawnTracerEntity2(world, shooter, startPos, lookVector);
        }
    }

    public static void spawnTracerEntity(Level world, Entity shooter, Vec3 startPos, Vec3 direction) {
        if (world.f_46443_) {
            return;
        }
        TracerEffectEntity tracer = new TracerEffectEntity((EntityType<TracerEffectEntity>)((EntityType)FelsMgrwwiiModEntities.TRACER_EFFECT.get()), world);
        if (tracer == null) {
            return;
        }
        tracer.m_7678_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, 0.0f, 0.0f);
        float yaw = (float)(Math.atan2(-direction.f_82479_, direction.f_82481_) * 57.29577951308232);
        float pitch = (float)(Math.asin(direction.f_82480_) * 57.29577951308232);
        tracer.m_146922_(yaw);
        tracer.m_146926_(pitch);
        tracer.f_19859_ = yaw;
        tracer.f_19860_ = pitch;
        tracer.m_5616_(yaw);
        tracer.m_5618_(yaw);
        double speed = 5.0;
        tracer.m_20256_(direction.m_82541_().m_82490_(speed));
        world.m_7967_((Entity)tracer);
    }

    public static void spawnTracerEntity2(Level world, Entity shooter, Vec3 startPos, Vec3 direction) {
        if (world.f_46443_) {
            return;
        }
        TracerEffect2Entity tracer = new TracerEffect2Entity((EntityType<TracerEffect2Entity>)((EntityType)FelsMgrwwiiModEntities.TRACER_EFFECT_2.get()), world);
        if (tracer == null) {
            return;
        }
        tracer.m_7678_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, 0.0f, 0.0f);
        float yaw = (float)(Math.atan2(-direction.f_82479_, direction.f_82481_) * 57.29577951308232);
        float pitch = (float)(Math.asin(direction.f_82480_) * 57.29577951308232);
        tracer.m_146922_(yaw);
        tracer.m_146926_(pitch);
        tracer.f_19859_ = yaw;
        tracer.f_19860_ = pitch;
        tracer.m_5616_(yaw);
        tracer.m_5618_(yaw);
        double speed = 5.0;
        tracer.m_20256_(direction.m_82541_().m_82490_(speed));
        world.m_7967_((Entity)tracer);
    }
}

