/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class InventoryUpgrade
implements Container {
    private static final int upgradeCapacity = 7;
    private final BlockEntityDrawers blockEntityDrawers;

    public InventoryUpgrade(BlockEntityDrawers blockEntityDrawers) {
        this.blockEntityDrawers = blockEntityDrawers;
    }

    public int m_6643_() {
        return 7;
    }

    public boolean m_7983_() {
        if (this.blockEntityDrawers == null) {
            return true;
        }
        for (int i = 0; i < 7; ++i) {
            if (this.blockEntityDrawers.upgrades().getUpgrade(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        if (this.blockEntityDrawers == null) {
            return ItemStack.f_41583_;
        }
        return this.blockEntityDrawers.upgrades().getUpgrade(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int count) {
        if (this.blockEntityDrawers == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.blockEntityDrawers.upgrades().getUpgrade(slot);
        if (count > 0) {
            this.blockEntityDrawers.upgrades().setUpgrade(slot, ItemStack.f_41583_);
        }
        return stack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, @NotNull ItemStack item) {
        if (this.blockEntityDrawers == null) {
            return;
        }
        this.blockEntityDrawers.upgrades().setUpgrade(slot, item);
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6596_() {
        if (this.blockEntityDrawers == null) {
            return;
        }
        this.blockEntityDrawers.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        BlockPos pos = this.blockEntityDrawers.m_58899_();
        if (this.blockEntityDrawers.m_58904_() == null || this.blockEntityDrawers.m_58904_().m_7702_(pos) != this.blockEntityDrawers) {
            return false;
        }
        return !(player.m_20238_(Vec3.m_82512_((Vec3i)pos)) > 64.0);
    }

    public void m_5856_(@NotNull Player player) {
    }

    public void m_5785_(@NotNull Player player) {
    }

    public boolean m_7013_(int slot, @NotNull ItemStack item) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canAddUpgrade(item);
    }

    public void m_6211_() {
    }

    public int getStorageMultiplier() {
        if (this.blockEntityDrawers == null) {
            return 1;
        }
        return this.blockEntityDrawers.upgrades().getStorageMultiplier();
    }

    public int getStackCapacity() {
        if (this.blockEntityDrawers == null) {
            return 1;
        }
        try {
            return Math.multiplyExact(this.blockEntityDrawers.getEffectiveDrawerCapacity(), this.blockEntityDrawers.upgrades().getStorageMultiplier());
        }
        catch (ArithmeticException e) {
            return 0x1FFFFFF;
        }
    }

    public boolean slotIsLocked(int slot) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return true;
        }
        if (!this.m_8020_(slot).m_41619_()) {
            return !this.canRemoveUpgrade(slot);
        }
        return false;
    }

    public boolean canAddUpgrade(@NotNull ItemStack item) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canAddUpgrade(item);
    }

    public boolean canRemoveUpgrade(int slot) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canRemoveUpgrade(slot);
    }

    public boolean canRemoveStorageUpgrade(int slot) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canRemoveUpgrade(slot);
    }

    public boolean canSwapUpgrade(int slot, @NotNull ItemStack item) {
        if (this.blockEntityDrawers == null) {
            return false;
        }
        if (this.blockEntityDrawers.hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            return false;
        }
        if (item.m_41613_() > 1) {
            return false;
        }
        return this.blockEntityDrawers.upgrades().canSwapUpgrade(slot, item);
    }
}

