/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpriteReplacementModel
extends ParentModel {
    private TextureAtlasSprite sprite;
    private Map<String, List<BakedQuad>> cache = new HashMap<String, List<BakedQuad>>();

    public SpriteReplacementModel(@NotNull BakedModel parent, TextureAtlasSprite sprite) {
        super(parent);
        this.sprite = sprite;
    }

    public SpriteReplacementModel(@NotNull BakedModel parent, BakedModel replacement) {
        super(parent);
        this.sprite = replacement.m_6160_();
    }

    public SpriteReplacementModel(@NotNull BakedModel parent, ItemStack stack) {
        super(parent);
        Item item;
        if (stack != null && (item = stack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            BlockRenderDispatcher disp = Minecraft.m_91087_().m_91289_();
            BakedModel model = disp.m_110910_(block.m_49966_());
            this.sprite = model.m_6160_();
        }
    }

    @Override
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction dir, RandomSource rand) {
        if (this.sprite == null) {
            return super.m_213637_(state, dir, rand);
        }
        String key = this.cacheKey(state, dir);
        List<BakedQuad> list = this.cache.getOrDefault(key, null);
        if (list == null) {
            list = super.m_213637_(state, dir, rand).stream().map(bakedQuad -> new ReplacementBakedQuad((BakedQuad)bakedQuad, this.sprite)).toList();
            this.cache.put(key, list);
        }
        return list;
    }

    @Override
    public TextureAtlasSprite m_6160_() {
        if (this.sprite == null) {
            return super.m_6160_();
        }
        return this.sprite;
    }

    private String cacheKey(@Nullable BlockState state, @Nullable Direction dir) {
        return (state != null ? state.toString() : "") + "#" + (dir != null ? dir.toString() : "");
    }

    private static class ReplacementBakedQuad
    extends BakedQuad {
        TextureAtlasSprite sprite;

        public ReplacementBakedQuad(BakedQuad quad, @NotNull TextureAtlasSprite sprite) {
            super((int[])quad.m_111303_().clone(), quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
            this.sprite = sprite;
            this.remapQuad();
        }

        @NotNull
        public TextureAtlasSprite m_173410_() {
            return this.sprite;
        }

        private void remapQuad() {
            int uvIndex = 4;
            for (int i = 0; i < 4; ++i) {
                int blk = DefaultVertexFormat.f_85811_.m_86017_() * i;
                this.f_111292_[blk + uvIndex] = Float.floatToRawIntBits(this.sprite.m_118367_((double)this.getUnInterpolatedU(this.f_111295_, Float.intBitsToFloat(this.f_111292_[blk + uvIndex]))));
                this.f_111292_[blk + uvIndex + 1] = Float.floatToRawIntBits(this.sprite.m_118393_((double)this.getUnInterpolatedV(this.f_111295_, Float.intBitsToFloat(this.f_111292_[blk + uvIndex + 1]))));
            }
        }

        private float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
            float diff = sprite.m_118410_() - sprite.m_118409_();
            return (u - sprite.m_118409_()) / diff * 16.0f;
        }

        private float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
            float diff = sprite.m_118412_() - sprite.m_118411_();
            return (v - sprite.m_118411_()) / diff * 16.0f;
        }
    }
}

