/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.simibubi.create.foundation.utility.Components;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public record InvalidCastingError(BlockPos pos, Fluid fluid, CannonCastShape shape) {
    public static void write(CompoundTag tag, @Nullable InvalidCastingError error) {
        if (error == null) {
            return;
        }
        CompoundTag errorTag = new CompoundTag();
        errorTag.m_128365_("Position", (Tag)NbtUtils.m_129224_((BlockPos)error.pos));
        errorTag.m_128359_("Fluid", CBCRegistryUtils.getFluidLocation(error.fluid).toString());
        errorTag.m_128359_("CastShape", CBCRegistries.cannonCastShapes().m_7981_((Object)error.shape).toString());
        tag.m_128365_("CastingError", (Tag)errorTag);
    }

    @Nullable
    public static InvalidCastingError read(CompoundTag tag) {
        if (!tag.m_128425_("CastingError", 10)) {
            return null;
        }
        CompoundTag errorTag = tag.m_128469_("CastingError");
        if (!errorTag.m_128425_("Position", 10)) {
            return null;
        }
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)errorTag.m_128469_("Position"));
        if (!errorTag.m_128425_("Fluid", 8)) {
            return null;
        }
        Fluid fluid = CBCRegistryUtils.getFluid(CBCUtils.location(errorTag.m_128461_("Fluid")));
        if (!errorTag.m_128425_("CastShape", 8)) {
            return null;
        }
        CannonCastShape shape = (CannonCastShape)CBCRegistries.cannonCastShapes().m_7745_(CBCUtils.location(errorTag.m_128461_("CastShape")));
        return new InvalidCastingError(pos, fluid, shape);
    }

    public MutableComponent getMessage() {
        MutableComponent fluidText = Components.translatable((String)Util.m_137492_((String)"fluid", (ResourceLocation)CBCRegistryUtils.getFluidLocation(this.fluid)));
        MutableComponent shapeText = Components.translatable((String)Util.m_137492_((String)"cast_shape", (ResourceLocation)CBCRegistries.cannonCastShapes().m_7981_((Object)this.shape)));
        return Components.translatable((String)"exception.createbigcannons.casting", (Object[])new Object[]{this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), fluidText, shapeText});
    }
}

