/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_hit_effects;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.tag_utils.TypeAndTagDataHolder;
import rbasamoyai.createbigcannons.block_hit_effects.BlockHitEffect;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class BlockHitEffectsHandler {
    private static final TypeAndTagDataHolder<Block, BlockHitEffect> BLOCKS = new TypeAndTagDataHolder(CBCRegistryUtils.getBlockRegistry());
    private static final TypeAndTagDataHolder<Block, BlockHitEffect> FLUIDS = new TypeAndTagDataHolder(CBCRegistryUtils.getBlockRegistry());

    public static void loadTags() {
        BLOCKS.loadTags();
        FLUIDS.loadTags();
    }

    public static void cleanUpTags() {
        BLOCKS.cleanUpTags();
        FLUIDS.cleanUpTags();
    }

    @Nullable
    public static BlockHitEffect getBlockProperties(BlockState state) {
        return BlockHitEffectsHandler.getBlockProperties(state.m_60734_());
    }

    @Nullable
    public static BlockHitEffect getBlockProperties(Block block) {
        return BLOCKS.getData(block);
    }

    @Nullable
    public static BlockHitEffect getFluidProperties(BlockState state) {
        return BlockHitEffectsHandler.getFluidProperties(state.m_60734_());
    }

    @Nullable
    public static BlockHitEffect getFluidProperties(Block block) {
        return FLUIDS.getData(block);
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener BLOCKS_INSTANCE = new ReloadListener("block", BLOCKS);
        public static final ReloadListener FLUIDS_INSTANCE = new ReloadListener("fluid", FLUIDS);
        private final TypeAndTagDataHolder<Block, BlockHitEffect> holder;

        ReloadListener(String suffix, TypeAndTagDataHolder<Block, BlockHitEffect> holder) {
            super(GSON, "block_hit_effects/" + suffix);
            this.holder = holder;
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
            this.holder.cleanUp();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    ResourceLocation loc = entry.getKey();
                    if (loc.m_135815_().startsWith("tags/")) {
                        ResourceLocation pruned = CBCUtils.location(loc.m_135827_(), loc.m_135815_().substring(5));
                        TagKey tag = TagKey.m_203882_(CBCRegistryUtils.getBlockRegistryKey(), (ResourceLocation)pruned);
                        this.holder.addTagData((TagKey<Block>)tag, BlockHitEffect.fromJson(el.getAsJsonObject()));
                        continue;
                    }
                    Block block = CBCRegistryUtils.getOptionalBlock(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                    this.holder.addData(block, BlockHitEffect.fromJson(el.getAsJsonObject()));
                }
                catch (Exception e) {
                    CreateBigCannons.LOGGER.warn("Exception loading block hit effects: {}", (Object)e.getMessage());
                }
            }
            BlockHitEffectsHandler.loadTags();
        }
    }
}

