/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class LiquidFuelType {
    private final List<Supplier<Fluid>> fluids = new ArrayList<Supplier<Fluid>>();
    private final List<Supplier<TagKey<Fluid>>> fluidTags = new ArrayList<Supplier<TagKey<Fluid>>>();
    private int fuelTicks = 40;
    private boolean invalid = false;

    public List<Supplier<Fluid>> getFluids() {
        return this.fluids;
    }

    public List<Supplier<TagKey<Fluid>>> getFluidTags() {
        return this.fluidTags;
    }

    public int getFuelTicks() {
        return this.fuelTicks;
    }

    public boolean getInvalid() {
        return this.invalid;
    }

    public static LiquidFuelType fromJson(JsonObject object) {
        LiquidFuelType type = new LiquidFuelType();
        try {
            JsonElement fluidsElement = object.get("fluids");
            if (fluidsElement != null && fluidsElement.isJsonArray()) {
                for (JsonElement element : fluidsElement.getAsJsonArray()) {
                    JsonPrimitive primitive2;
                    if (!element.isJsonPrimitive() || !(primitive2 = element.getAsJsonPrimitive()).isString()) continue;
                    try {
                        String string = primitive2.getAsString();
                        if (string.startsWith("#")) {
                            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation(primitive2.getAsString().substring(1)));
                            if (tag == null) continue;
                            type.fluidTags.add(() -> tag);
                            continue;
                        }
                        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(primitive2.getAsString()));
                        if (fluid == null) continue;
                        type.fluids.add(() -> fluid);
                    }
                    catch (ResourceLocationException resourceLocationException) {}
                }
            } else {
                return null;
            }
            LiquidFuelType.parseJsonPrimitive(object, "fuel_ticks", JsonPrimitive::isNumber, primitive -> {
                type.fuelTicks = primitive.getAsInt();
            });
            LiquidFuelType.parseJsonPrimitive(object, "invalid", JsonPrimitive::isBoolean, primitive -> {
                type.invalid = primitive.getAsBoolean();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private static void parseJsonPrimitive(JsonObject object, String key, Predicate<JsonPrimitive> predicate, Consumer<JsonPrimitive> consumer) {
        JsonPrimitive primitive;
        JsonElement element = object.get(key);
        if (element != null && element.isJsonPrimitive() && predicate.test(primitive = element.getAsJsonPrimitive())) {
            consumer.accept(primitive);
        }
    }
}

