/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.recipe;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.recipe.RailwaysRecipeProvider;
import com.railwayteam.railways.base.data.recipe.RailwaysSequencedAssemblyRecipeBuilder;
import com.railwayteam.railways.compat.tracks.TrackCompatUtils;
import com.railwayteam.railways.mixin.AccessorIngredient_TagValue;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeBuilder;
import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RailwaysSequencedAssemblyRecipeGen
extends RailwaysRecipeProvider {
    final EnumMap<DyeColor, RailwaysRecipeProvider.GeneratedRecipe> CONDUCTOR_CAPS = new EnumMap(DyeColor.class);
    final Map<TrackMaterial, RailwaysRecipeProvider.GeneratedRecipe> TRACKS = new HashMap<TrackMaterial, RailwaysRecipeProvider.GeneratedRecipe>();

    public RailwaysSequencedAssemblyRecipeGen(PackOutput output) {
        super(output);
        for (DyeColor color : DyeColor.values()) {
            String colorName = TextUtils.titleCaseConversion(color.m_41065_().replace("_", " "));
            String colorReg = color.m_41065_().toLowerCase(Locale.ROOT);
            this.CONDUCTOR_CAPS.put(color, this.create(colorReg + "_conductor_cap", b -> b.require((ItemLike)CRItems.woolByColor(color)).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_CONDUCTOR_CAP.get(color).get()).addOutput((ItemLike)CRItems.ITEM_CONDUCTOR_CAP.get(color).get(), 1.0f).loops(1).addStep(CuttingRecipe::new, rb -> rb).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.precisionMechanism())).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.string()))));
        }
        ArrayList trackMaterials = new ArrayList(TrackMaterial.allFromMod((String)"railways"));
        for (String mod : TrackCompatUtils.TRACK_COMPAT_MODS) {
            trackMaterials.addAll(TrackMaterial.allFromMod((String)mod));
        }
        for (TrackMaterial material : trackMaterials) {
            if (material.railsIngredient.m_43947_() || material.sleeperIngredient.m_43947_()) {
                Ingredient sleeperIngredient;
                TrackMaterial baseMaterial;
                if (material.trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                    baseMaterial = CRTrackMaterials.getBaseFromWide(material);
                    if (baseMaterial == null || (sleeperIngredient = material == CRTrackMaterials.WIDE_GAUGE_ANDESITE ? Ingredient.m_204132_((TagKey)AllTags.AllItemTags.SLEEPERS.tag) : baseMaterial.sleeperIngredient).m_43947_()) continue;
                    this.TRACKS.put(material, this.create("track_" + (String)(material.id.m_135827_().equals("railways") ? "" : material.id.m_135827_() + "_") + material.resourceName(), b -> b.conditionalMaterial(material).require((ItemLike)baseMaterial.getBlock()).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(material).get()).addOutput((ItemLike)material.getBlock(), 1.0f).loops(1).addStep(CuttingRecipe::new, rb -> rb).addStep(DeployerApplicationRecipe::new, rb -> rb.require(sleeperIngredient)).addStep(PressingRecipe::new, rb -> rb)));
                    continue;
                }
                if (material.trackType != CRTrackMaterials.CRTrackType.NARROW_GAUGE || (baseMaterial = CRTrackMaterials.getBaseFromNarrow(material)) == null || (sleeperIngredient = material == CRTrackMaterials.NARROW_GAUGE_ANDESITE ? Ingredient.m_204132_((TagKey)AllTags.AllItemTags.SLEEPERS.tag) : baseMaterial.sleeperIngredient).m_43947_() || baseMaterial.railsIngredient.m_43947_()) continue;
                Ingredient railsIngredient = baseMaterial.railsIngredient;
                if (railsIngredient.f_43902_.length == 2 && Arrays.stream(railsIngredient.f_43902_).allMatch(value -> {
                    Ingredient.TagValue tagValue;
                    return value instanceof Ingredient.TagValue && (((AccessorIngredient_TagValue)(tagValue = (Ingredient.TagValue)value)).getTag().equals((Object)AllTags.forgeItemTag((String)"nuggets/iron")) || ((AccessorIngredient_TagValue)tagValue).getTag().equals((Object)AllTags.forgeItemTag((String)"nuggets/zinc")) || ((AccessorIngredient_TagValue)tagValue).getTag().equals((Object)AllTags.forgeItemTag((String)"iron_nuggets")) || ((AccessorIngredient_TagValue)tagValue).getTag().equals((Object)AllTags.forgeItemTag((String)"zinc_nuggets")));
                })) {
                    railsIngredient = Ingredient.m_43938_(Stream.of(AccessorIngredient_TagValue.railways$create(RailwaysRecipeProvider.Ingredients.ironNugget()), AccessorIngredient_TagValue.railways$create(RailwaysRecipeProvider.Ingredients.zincNugget())));
                }
                Ingredient finalRailsIngredient = railsIngredient;
                this.TRACKS.put(material, this.create("track_" + (String)(material.id.m_135827_().equals("railways") ? "" : material.id.m_135827_() + "_") + material.resourceName(), b -> b.conditionalMaterial(material).require(sleeperIngredient).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(material).get()).addOutput((ItemLike)material.getBlock(), 1.0f).loops(1).addStep(CuttingRecipe::new, rb -> rb).addStep(DeployerApplicationRecipe::new, rb -> rb.require(finalRailsIngredient)).addStep(PressingRecipe::new, rb -> rb)));
                continue;
            }
            Ingredient railsIngredient = material.railsIngredient;
            if (railsIngredient.f_43902_.length == 2 && Arrays.stream(railsIngredient.f_43902_).allMatch(value -> {
                Ingredient.TagValue tagValue;
                return value instanceof Ingredient.TagValue && (((AccessorIngredient_TagValue)(tagValue = (Ingredient.TagValue)value)).getTag().equals((Object)AllTags.forgeItemTag((String)"nuggets/iron")) || ((AccessorIngredient_TagValue)tagValue).getTag().equals((Object)AllTags.forgeItemTag((String)"nuggets/zinc")) || ((AccessorIngredient_TagValue)tagValue).getTag().equals((Object)AllTags.forgeItemTag((String)"iron_nuggets")) || ((AccessorIngredient_TagValue)tagValue).getTag().equals((Object)AllTags.forgeItemTag((String)"zinc_nuggets")));
            })) {
                railsIngredient = Ingredient.m_43938_(Stream.of(AccessorIngredient_TagValue.railways$create(RailwaysRecipeProvider.Ingredients.ironNugget()), AccessorIngredient_TagValue.railways$create(RailwaysRecipeProvider.Ingredients.zincNugget())));
            }
            Ingredient finalRailsIngredient = railsIngredient;
            this.TRACKS.put(material, this.create("track_" + (String)(material.id.m_135827_().equals("railways") ? "" : material.id.m_135827_() + "_") + material.resourceName(), b -> b.conditionalMaterial(material).require(material.sleeperIngredient).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(material).get()).addOutput((ItemLike)material.getBlock(), 1.0f).loops(1).addStep(DeployerApplicationRecipe::new, rb -> rb.require(finalRailsIngredient)).addStep(DeployerApplicationRecipe::new, rb -> rb.require(finalRailsIngredient)).addStep(PressingRecipe::new, rb -> rb)));
        }
        this.TRACKS.put(CRTrackMaterials.PHANTOM, this.create("track_phantom", b -> b.require(RailwaysRecipeProvider.Ingredients.phantomMembrane()).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(CRTrackMaterials.PHANTOM).get()).addOutput(new ItemStack((ItemLike)CRTrackMaterials.PHANTOM.getBlock(), 32), 1.0f).loops(1).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.ironIngot())).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.ironIngot())).addStep(PressingRecipe::new, rb -> rb)));
        this.TRACKS.put(CRTrackMaterials.MONORAIL, this.create("track_monorail", b -> b.require(RailwaysRecipeProvider.Ingredients.girder()).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(CRTrackMaterials.MONORAIL).get()).addOutput(new ItemStack((ItemLike)CRTrackMaterials.MONORAIL.getBlock(), 6), 1.0f).loops(1).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.metalBracket())).addStep(DeployerApplicationRecipe::new, rb -> rb.require(RailwaysRecipeProvider.Ingredients.ironSheet())).addStep(PressingRecipe::new, rb -> rb)));
    }

    protected RailwaysRecipeProvider.GeneratedRecipe create(String name, Function<RailwaysSequencedAssemblyRecipeBuilder, SequencedAssemblyRecipeBuilder> transform) {
        RailwaysRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((SequencedAssemblyRecipeBuilder)transform.apply(new RailwaysSequencedAssemblyRecipeBuilder(Railways.asResource(name)))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    @NotNull
    public String m_6055_() {
        return "Railways' Sequenced Assembly Recipes";
    }
}

