/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.lights.neon;

import com.drmangotea.tfmg.base.MaxBlockVoltage;
import com.drmangotea.tfmg.blocks.electricity.cable_blocks.CableTubeBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.lights.neon.NeonTubeBlock;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NeonTubeBlockEntity
extends CableTubeBlockEntity {
    public DyeColor color;
    boolean shouldDestroy = false;
    int red = 250;
    int green = 0;
    int blue = 0;
    public LerpedFloat glow = LerpedFloat.linear();

    public NeonTubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.color = DyeColor.WHITE;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.getOrCreateElectricNetwork().requestEnergy(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.shouldDestroy) {
            this.f_58857_.m_46961_(this.m_58899_(), false);
            return;
        }
        if (this.energy.getEnergyStored() != 0 && this.getVoltage() != 0) {
            this.glow.chase((double)this.getVoltage(), 0.4, LerpedFloat.Chaser.EXP);
            this.glow.tickChaser();
            if (this.getVoltage() != 0) {
                this.useEnergy(1);
                if (!((Boolean)this.m_58900_().m_61143_((Property)NeonTubeBlock.ACTIVE)).booleanValue()) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)NeonTubeBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
        } else {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)NeonTubeBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
            this.glow.chase(0.0, 0.4, LerpedFloat.Chaser.EXP);
            this.glow.tickChaser();
        }
    }

    @Override
    public void voltageFailure() {
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 2.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 0.8f);
        this.f_58857_.m_46961_(this.m_58899_(), false);
        this.shouldDestroy = true;
        this.sendStuff();
    }

    public void setColor(DyeColor color) {
        if (color == DyeColor.BLACK || color == DyeColor.LIGHT_GRAY || color == DyeColor.GRAY) {
            this.changeColor();
        }
        this.color = color;
        this.notifyUpdate();
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.NEON_TUBE.get());
    }

    public void changeColor() {
        this.red = Create.RANDOM.nextInt(255);
        this.green = Create.RANDOM.nextInt(255);
        this.blue = Create.RANDOM.nextInt(255);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        NBTHelper.writeEnum((CompoundTag)compound, (String)"color", (Enum)this.color);
        compound.m_128405_("red", this.red);
        compound.m_128405_("green", this.green);
        compound.m_128405_("blue", this.blue);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.color = (DyeColor)NBTHelper.readEnum((CompoundTag)compound, (String)"color", DyeColor.class);
        this.red = compound.m_128451_("red");
        this.green = compound.m_128451_("green");
        this.blue = compound.m_128451_("blue");
    }
}

