/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.util;

import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.particles.TrailData;

public class GunEnchantmentHelper {
    public static ParticleOptions getParticle(ItemStack weapon) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)weapon);
        if (enchantments.containsKey(ModEnchantments.FIRE_STARTER.get())) {
            return ParticleTypes.f_123756_;
        }
        if (enchantments.containsKey(ModEnchantments.PUNCTURING.get())) {
            return ParticleTypes.f_123808_;
        }
        return new TrailData(weapon.m_41793_());
    }

    public static int getRealReloadSpeed(ItemStack weapon) {
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        if (modifiedGun.getReloads().getReloadType() == ReloadType.MAG_FED) {
            return GunEnchantmentHelper.getMagReloadSpeed(weapon);
        }
        return GunEnchantmentHelper.getReloadInterval(weapon);
    }

    public static int getReloadInterval(ItemStack weapon) {
        int interval = 10;
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.QUICK_HANDS.get()), (ItemStack)weapon);
        if (level > 0) {
            interval -= 3 * level;
        }
        return Math.max(interval, 1);
    }

    public static int getMagReloadSpeed(ItemStack weapon) {
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        int modifier = 1;
        if (Gun.getAttachment(IAttachment.Type.MAGAZINE, weapon).m_41720_() == ModItems.EXTENDED_MAG.get()) {
            modifier = 2;
        }
        if (Gun.getAttachment(IAttachment.Type.MAGAZINE, weapon).m_41720_() == ModItems.DRUM_MAG.get()) {
            modifier = 3;
        }
        int speed = modifiedGun.getReloads().getAdditionalReloadTimer() + modifiedGun.getReloads().getReloadTimer() * modifier;
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.QUICK_HANDS.get()), (ItemStack)weapon);
        if (level > 0) {
            speed -= Math.round(speed / 4 * level);
        }
        return Math.max(speed, 4);
    }

    public static int getRate(ItemStack weapon, Gun modifiedGun) {
        int rate = modifiedGun.getGeneral().getRate();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.TRIGGER_FINGER.get()), (ItemStack)weapon);
        if (level > 0) {
            float newRate = (float)rate * (0.25f * (float)level);
            rate = (int)((float)rate - Mth.m_14036_((float)newRate, (float)0.0f, (float)rate));
        }
        return rate;
    }

    public static double getAimDownSightSpeed(ItemStack weapon) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.LIGHTWEIGHT.get()), (ItemStack)weapon);
        return level > 0 ? 1.5 : 1.0;
    }

    public static double getProjectileSpeedModifier(ItemStack weapon) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ACCELERATOR.get()), (ItemStack)weapon);
        if (level > 0) {
            return 1.0 + 0.5 * (double)level;
        }
        return 1.0;
    }

    public static float getAcceleratorDamage(ItemStack weapon, float damage) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ACCELERATOR.get()), (ItemStack)weapon);
        if (level > 0) {
            return damage + damage * (0.1f * (float)level);
        }
        return damage;
    }

    public static float getWitheredDamage(ItemStack weapon, float damage) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.WITHERED.get()), (ItemStack)weapon);
        if (level > 0) {
            return damage * (float)Math.pow(1.15, level);
        }
        return damage;
    }

    public static float getPuncturingChance(ItemStack weapon) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.PUNCTURING.get()), (ItemStack)weapon);
        return (float)level * 0.05f;
    }

    public static int getQuickHands(ItemStack weapon) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.QUICK_HANDS.get()), (ItemStack)weapon);
    }
}

