/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.handler.AimingHandler;
import ttv.migami.jeg.client.handler.ShootingHandler;
import ttv.migami.jeg.client.medal.MedalManager;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.TelescopicScopeItem;
import ttv.migami.jeg.item.attachment.IAttachment;

@Mod.EventBusSubscriber(modid="jeg", value={Dist.CLIENT})
public class GuiRenderer {
    protected static final ResourceLocation SPYGLASS_SCOPE_LOCATION = new ResourceLocation("textures/misc/spyglass_scope.png");
    protected static final ResourceLocation LONG_SCOPE_OVERLAY = new ResourceLocation("jeg", "textures/scope_long_overlay.png");
    protected static final ResourceLocation AMMO = new ResourceLocation("jeg", "textures/gui/ammo/bullet.png");
    protected static final ResourceLocation SHELL = new ResourceLocation("jeg", "textures/gui/ammo/shell.png");
    protected static final ResourceLocation OVERHEAT = new ResourceLocation("jeg", "textures/gui/timer/overheat.png");
    protected static final ResourceLocation POWER = new ResourceLocation("jeg", "textures/gui/timer/power.png");
    protected static final ResourceLocation HOLD = new ResourceLocation("jeg", "textures/gui/timer/hold.png");
    protected static int screenWidth;
    protected static int screenHeight;
    protected static float scopeScale;

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        screenWidth = minecraft.m_91268_().m_85445_();
        screenHeight = minecraft.m_91268_().m_85446_();
        float f = minecraft.m_91297_();
        scopeScale = Mth.m_14179_((float)(0.5f * f), (float)scopeScale, (float)1.125f);
        if (minecraft.f_91066_.m_92176_().m_90612_()) {
            if (AimingHandler.get().isAiming() || player.m_21211_().m_41720_() instanceof TelescopicScopeItem) {
                if (event.getOverlay() == VanillaGuiOverlay.SPYGLASS.type()) {
                    if (Gun.getAttachment(IAttachment.Type.SCOPE, player.m_21205_()).m_41720_() instanceof TelescopicScopeItem) {
                        GuiRenderer.renderSpyglassOverlay(event.getGuiGraphics(), scopeScale, LONG_SCOPE_OVERLAY);
                    }
                    if (Gun.getAttachment(IAttachment.Type.SCOPE, player.m_21205_()).m_150930_(Items.f_151059_)) {
                        GuiRenderer.renderSpyglassOverlay(event.getGuiGraphics(), scopeScale, SPYGLASS_SCOPE_LOCATION);
                    }
                }
            } else {
                scopeScale = 0.5f;
            }
        }
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            Item item;
            MedalManager.render(event.getGuiGraphics());
            ItemStack heldItem = player.m_21205_();
            if (!heldItem.m_41619_() && (item = heldItem.m_41720_()) instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                CompoundTag tag = heldItem.m_41783_();
                if (tag == null) {
                    return;
                }
                Gun gun = gunItem.getModifiedGun(heldItem);
                GuiGraphics guiGraphics = event.getGuiGraphics();
                if (((Boolean)Config.CLIENT.display.showTimersGUI.get()).booleanValue()) {
                    boolean renderWhileAiming;
                    if (!((Boolean)Config.CLIENT.display.aimingHidesTimers.get()).booleanValue()) {
                        renderWhileAiming = true;
                    } else {
                        boolean bl = renderWhileAiming = !AimingHandler.get().isAiming();
                    }
                    if (AimingHandler.get().getNormalisedAdsProgress() > 0.5 && !minecraft.f_91066_.m_92176_().m_90612_()) {
                        renderWhileAiming = true;
                    }
                    if (renderWhileAiming) {
                        int width;
                        float progress;
                        if (gun.getGeneral().getFireTimer() != 0) {
                            RenderSystem.enableBlend();
                            RenderSystem.defaultBlendFunc();
                            guiGraphics.m_280163_(HOLD, minecraft.m_91268_().m_85445_() / 2 - 32, minecraft.m_91268_().m_85446_() / 2 + 38, 0.0f, 0.0f, 64, 6, 64, 12);
                            RenderSystem.disableBlend();
                            float fireTimer = gun.getGeneral().getFireTimer();
                            float currentFireTimer = ShootingHandler.get().getFireTimer();
                            progress = currentFireTimer / fireTimer;
                            width = (int)(64.0f * progress);
                            guiGraphics.m_280163_(HOLD, minecraft.m_91268_().m_85445_() / 2 - 32, minecraft.m_91268_().m_85446_() / 2 + 38, 0.0f, 6.0f, width, 6, 64, 12);
                        }
                        if (gun.getGeneral().getMaxHoldFire() != 0) {
                            RenderSystem.enableBlend();
                            RenderSystem.defaultBlendFunc();
                            guiGraphics.m_280163_(POWER, minecraft.m_91268_().m_85445_() / 2 - 32, minecraft.m_91268_().m_85446_() / 2 + 31, 0.0f, 0.0f, 64, 6, 64, 12);
                            RenderSystem.disableBlend();
                            float maxHoldTimer = gun.getGeneral().getMaxHoldFire();
                            float currentHoldTimer = ShootingHandler.get().getHoldFire();
                            progress = currentHoldTimer / maxHoldTimer;
                            width = (int)(64.0f * progress);
                            guiGraphics.m_280163_(POWER, minecraft.m_91268_().m_85445_() / 2 - 32, minecraft.m_91268_().m_85446_() / 2 + 31, 0.0f, 6.0f, width, 6, 64, 12);
                        }
                        if (gun.getGeneral().getOverheatTimer() != 0) {
                            RenderSystem.enableBlend();
                            RenderSystem.defaultBlendFunc();
                            guiGraphics.m_280163_(OVERHEAT, minecraft.m_91268_().m_85445_() / 2 - 32, minecraft.m_91268_().m_85446_() / 2 + 24, 0.0f, 0.0f, 64, 6, 64, 12);
                            RenderSystem.disableBlend();
                            float maxOverheatTimer = gun.getGeneral().getOverheatTimer();
                            float currentOverheatTimer = ShootingHandler.get().getOverheatTimer();
                            progress = currentOverheatTimer / maxOverheatTimer;
                            width = (int)(64.0f * progress);
                            guiGraphics.m_280163_(OVERHEAT, minecraft.m_91268_().m_85445_() / 2 - 32, minecraft.m_91268_().m_85446_() / 2 + 24, 0.0f, 6.0f, width, 6, 64, 12);
                        }
                    }
                }
                if (!((Boolean)Config.CLIENT.display.showAmmoGUI.get()).booleanValue()) {
                    return;
                }
                if (heldItem.m_150930_((Item)ModItems.FINGER_GUN.get())) {
                    return;
                }
                if (!tag.m_128441_("AmmoCount")) {
                    return;
                }
                int ammoCount = tag.m_128451_("AmmoCount");
                ItemStack[] ammoStack = !gun.getReloads().getReloadType().equals(ReloadType.SINGLE_ITEM) ? Gun.findAmmoStack((Player)player, gun.getProjectile().getItem()) : Gun.findAmmoStack((Player)player, gun.getReloads().getReloadItem());
                int startX = (int)((double)minecraft.m_91268_().m_85445_() * 0.95 - 100.0) + (Integer)Config.CLIENT.display.displayAmmoGUIXOffset.get();
                int startY = minecraft.m_91268_().m_85446_() - 65 + (Integer)Config.CLIENT.display.displayAmmoGUIYOffset.get();
                String name = heldItem.m_41786_().getString();
                guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, name, startX, startY - 10, heldItem.m_41791_().f_43022_.m_126665_().intValue(), true);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)startX, (float)startY, 0.0f);
                guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
                String ammoText = String.format("%03d", ammoCount);
                if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue() && !player.m_6047_()) {
                    ammoText = "Reloading";
                }
                guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, ammoText, 0, 0, 0xFFFFFF, true);
                guiGraphics.m_280168_().m_85849_();
                boolean showReserve = true;
                if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                    showReserve = player.m_6047_();
                }
                if (showReserve) {
                    String inventoryAmmo = String.format("%04d", ammoStack.length);
                    inventoryAmmo = gun.getReloads().getReloadType().equals(ReloadType.SINGLE_ITEM) ? String.format("%04d", ammoStack.length * gun.getReloads().getMaxAmmo()) : String.format("%04d", Gun.getTotalAmmoCount(ammoStack));
                    if (player.m_7500_() || heldItem.getEnchantmentLevel((Enchantment)ModEnchantments.INFINITY.get()) != 0 || heldItem.m_41783_().m_128471_("IgnoreAmmo")) {
                        inventoryAmmo = "9999";
                    }
                    guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, inventoryAmmo, startX + 38, startY, 0x878787, true);
                }
            }
        }
    }

    public static void renderSpyglassOverlay(GuiGraphics pGuiGraphics, float pScopeScale, ResourceLocation resourceLocation) {
        float f = Math.min(screenWidth, screenHeight);
        float f1 = Math.min((float)screenWidth / f, (float)screenHeight / f) * pScopeScale;
        int i = Mth.m_14143_((float)(f * f1));
        int j = Mth.m_14143_((float)(f * f1));
        int k = (screenWidth - i) / 2;
        int l = (screenHeight - j) / 2;
        int i1 = k + i;
        int j1 = l + j;
        pGuiGraphics.m_280398_(resourceLocation, k, l, -90, 0.0f, 0.0f, i, j, i, j);
        pGuiGraphics.m_285795_(RenderType.m_286086_(), 0, j1, screenWidth, screenHeight, -90, -16777216);
        pGuiGraphics.m_285795_(RenderType.m_286086_(), 0, 0, screenWidth, l, -90, -16777216);
        pGuiGraphics.m_285795_(RenderType.m_286086_(), 0, l, k, j1, -90, -16777216);
        pGuiGraphics.m_285795_(RenderType.m_286086_(), i1, l, screenWidth, j1, -90, -16777216);
    }
}

