/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.medal;

import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import ttv.migami.jeg.client.util.FPSUtil;

public class Medal {
    private final ResourceLocation texture;
    private final MutableComponent description;
    private int x;
    private int y;
    private float opacity;
    private double lifetime;
    private final float maxScale = 1.5f;
    private final float minScale = 1.0f;
    private float currentScale = 1.5f;
    private final SoundEvent sound;

    public Medal(ResourceLocation texture, int startX, int startY, double lifetime, MutableComponent description, SoundEvent sound) {
        this.texture = texture;
        this.x = startX;
        this.y = startY;
        this.opacity = 1.0f;
        this.lifetime = lifetime;
        this.description = description;
        this.sound = sound;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public MutableComponent getDescription() {
        return this.description;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public float getScale() {
        return this.currentScale;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public double getLifetime() {
        return this.lifetime;
    }

    public boolean tick() {
        this.lifetime -= 1.0 / FPSUtil.calc();
        if (this.lifetime < 20.0 * FPSUtil.calc()) {
            this.opacity = (float)Math.max(0.0, this.lifetime / 20.0);
        }
        if (this.lifetime < 40.0 * FPSUtil.calc()) {
            this.x += (int)(5.0 / FPSUtil.calc());
        }
        if (this.currentScale > 1.0f) {
            this.currentScale -= 0.05f;
        }
        return this.lifetime <= 0.0;
    }
}

